/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.basic;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ThreadSafeSimpleDateFormat {
    private String formatString;
    private DateFormat[] pool;
    private int nextAvailable = 0;

    public ThreadSafeSimpleDateFormat(String string, int n, int n2) {
        this.formatString = string;
        this.nextAvailable = -1;
        this.pool = new DateFormat[n2];
        for (int i = 0; i < n; ++i) {
            this.putInPool(this.createNew());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Date date) {
        DateFormat dateFormat = this.fetchFromPool();
        try {
            String string = dateFormat.format(date);
            return string;
        }
        finally {
            this.putInPool(dateFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parse(String string) throws ParseException {
        DateFormat dateFormat = this.fetchFromPool();
        try {
            Date date = dateFormat.parse(string);
            return date;
        }
        finally {
            this.putInPool(dateFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DateFormat fetchFromPool() {
        DateFormat[] dateFormatArray = this.pool;
        synchronized (this.pool) {
            while (this.nextAvailable < 0) {
                try {
                    this.pool.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Interrupted whilst waiting for a free item in the pool : " + interruptedException.getMessage());
                }
            }
            DateFormat dateFormat = this.pool[this.nextAvailable];
            --this.nextAvailable;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (dateFormat == null) {
                dateFormat = this.createNew();
                this.putInPool(dateFormat);
            }
            return dateFormat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInPool(DateFormat dateFormat) {
        DateFormat[] dateFormatArray = this.pool;
        synchronized (this.pool) {
            ++this.nextAvailable;
            this.pool[this.nextAvailable] = dateFormat;
            this.pool.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private DateFormat createNew() {
        return new SimpleDateFormat(this.formatString);
    }
}

