/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.util.HashMap;
import java.util.Map;

public class JVM {
    private static Map classCache = new HashMap();
    private static ReflectionProvider reflectionProvider;

    public static boolean is14() {
        return JVM.loadClass("java.util.LinkedHashMap") != null;
    }

    public static Class loadClass(String string) {
        if (classCache.containsKey(string)) {
            return (Class)classCache.get(string);
        }
        try {
            Class<?> clazz = Class.forName(string);
            classCache.put(string, clazz);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static synchronized ReflectionProvider bestReflectionProvider() {
        if (reflectionProvider == null) {
            try {
                if (JVM.loadClass("sun.misc.Unsafe") != null) {
                    String string = "com.thoughtworks.xstream.converters.reflection.Sun14ReflectionProvider";
                    reflectionProvider = (ReflectionProvider)JVM.loadClass(string).newInstance();
                } else {
                    reflectionProvider = new PureJavaReflectionProvider();
                }
            }
            catch (InstantiationException instantiationException) {
                reflectionProvider = new PureJavaReflectionProvider();
            }
            catch (IllegalAccessException illegalAccessException) {
                reflectionProvider = new PureJavaReflectionProvider();
            }
        }
        return reflectionProvider;
    }
}

