/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.collections;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Comparator;
import java.util.TreeMap;

public class TreeMapConverter
extends MapConverter {
    static /* synthetic */ Class class$java$util$TreeMap;

    public TreeMapConverter(ClassMapper classMapper, String string) {
        super(classMapper, string);
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(class$java$util$TreeMap == null ? (class$java$util$TreeMap = TreeMapConverter.class$("java.util.TreeMap")) : class$java$util$TreeMap);
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        TreeMap treeMap = (TreeMap)object;
        Comparator comparator = treeMap.comparator();
        if (comparator == null) {
            hierarchicalStreamWriter.startNode("no-comparator");
            hierarchicalStreamWriter.endNode();
        } else {
            hierarchicalStreamWriter.startNode("comparator");
            hierarchicalStreamWriter.addAttribute("class", this.classMapper.lookupName(comparator.getClass()));
            marshallingContext.convertAnother(comparator);
            hierarchicalStreamWriter.endNode();
        }
        super.marshal(object, hierarchicalStreamWriter, marshallingContext);
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        TreeMap treeMap;
        hierarchicalStreamReader.moveDown();
        if (hierarchicalStreamReader.getNodeName().equals("comparator")) {
            String string = hierarchicalStreamReader.getAttribute("class");
            Comparator comparator = (Comparator)unmarshallingContext.convertAnother(null, this.classMapper.lookupType(string));
            treeMap = new TreeMap(comparator);
        } else if (hierarchicalStreamReader.getNodeName().equals("no-comparator")) {
            treeMap = new TreeMap();
        } else {
            throw new ConversionException("TreeMap does not contain <comparator> element");
        }
        hierarchicalStreamReader.moveUp();
        super.populateMap(hierarchicalStreamReader, unmarshallingContext, treeMap);
        return treeMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

