/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.IOException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import sun.misc.CharacterDecoder;
import sun.misc.CharacterEncoder;

public class EncodedByteArrayConverter
implements Converter {
    private CharacterEncoder encoder;
    private CharacterDecoder decoder;

    public EncodedByteArrayConverter() {
        this.encoder = new BASE64Encoder();
        this.decoder = new BASE64Decoder();
    }

    public EncodedByteArrayConverter(CharacterEncoder characterEncoder, CharacterDecoder characterDecoder) {
        this.encoder = characterEncoder;
        this.decoder = characterDecoder;
    }

    public boolean canConvert(Class clazz) {
        return clazz.isArray() && clazz.getComponentType().equals(Byte.TYPE);
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        byte[] byArray = (byte[])object;
        hierarchicalStreamWriter.setValue(this.encoder.encode(byArray));
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        try {
            return this.decoder.decodeBuffer(hierarchicalStreamReader.getValue());
        }
        catch (IOException iOException) {
            throw new ConversionException("Cannot decode binary data", iOException);
        }
    }
}

