/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class FieldDictionary {
    private static final Map keyedByFieldNameCache = new TreeMap();
    private static final Map keyedByFieldKeyCache = new TreeMap();
    static /* synthetic */ Class class$java$lang$Object;

    public Iterator serializableFieldsFor(Class clazz) {
        return this.buildMap(clazz, true).values().iterator();
    }

    public Field field(Class clazz, String string, Class clazz2) {
        Map map = this.buildMap(clazz, clazz2 != null);
        Field field = (Field)map.get(clazz2 != null ? new FieldKey(string, clazz2) : string);
        if (field == null) {
            throw new ObjectAccessException("No such field " + clazz.getName() + "." + string);
        }
        return field;
    }

    private Map buildMap(Class clazz, boolean bl) {
        String string = clazz.getName();
        if (!keyedByFieldNameCache.containsKey(string)) {
            TreeMap<String, Field> treeMap = new TreeMap<String, Field>();
            TreeMap<FieldKey, Field> treeMap2 = new TreeMap<FieldKey, Field>();
            while (!(class$java$lang$Object == null ? FieldDictionary.class$("java.lang.Object") : class$java$lang$Object).equals(clazz)) {
                Field[] fieldArray = clazz.getDeclaredFields();
                for (int i = 0; i < fieldArray.length; ++i) {
                    Field field = fieldArray[i];
                    if (field.getName().startsWith("this$")) continue;
                    field.setAccessible(true);
                    if (!treeMap.containsKey(field.getName())) {
                        treeMap.put(field.getName(), field);
                    }
                    treeMap2.put(new FieldKey(field.getName(), field.getDeclaringClass()), field);
                }
                clazz = clazz.getSuperclass();
            }
            keyedByFieldNameCache.put(string, treeMap);
            keyedByFieldKeyCache.put(string, treeMap2);
        }
        return (Map)(bl ? keyedByFieldKeyCache.get(string) : keyedByFieldNameCache.get(string));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class FieldKey
    implements Comparable {
        private String fieldName;
        private Class declaringClass;
        private Integer depth;

        public FieldKey(String string, Class clazz) {
            this.fieldName = string;
            this.declaringClass = clazz;
            Class clazz2 = clazz;
            int n = 0;
            while (clazz2.getSuperclass() != null) {
                ++n;
                clazz2 = clazz2.getSuperclass();
            }
            this.depth = new Integer(n);
        }

        public int compareTo(Object object) {
            FieldKey fieldKey = (FieldKey)object;
            int n = this.fieldName.compareTo(fieldKey.fieldName);
            if (n == 0) {
                n = 0 - this.depth.compareTo(fieldKey.depth);
            }
            if (n == 0) {
                n = this.declaringClass.getName().compareTo(fieldKey.declaringClass.getName());
            }
            return n;
        }
    }
}

