/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.HashSet;

public class ReflectionConverter
implements Converter {
    private ClassMapper classMapper;
    private String classAttributeIdentifier;
    private String definedInAttributeIdentifier = "defined-in";
    private ReflectionProvider reflectionProvider;

    public ReflectionConverter(ClassMapper classMapper, String string, String string2, ReflectionProvider reflectionProvider) {
        this.classMapper = classMapper;
        this.classAttributeIdentifier = string;
        this.definedInAttributeIdentifier = string2;
        this.reflectionProvider = reflectionProvider;
    }

    public boolean canConvert(Class clazz) {
        return true;
    }

    public void marshal(Object object, final HierarchicalStreamWriter hierarchicalStreamWriter, final MarshallingContext marshallingContext) {
        final HashSet hashSet = new HashSet();
        this.reflectionProvider.visitSerializableFields(object, new ReflectionProvider.Visitor(){

            public void visit(String string, Class clazz, Class clazz2, Object object) {
                if (object != null) {
                    hierarchicalStreamWriter.startNode(ReflectionConverter.this.classMapper.mapNameToXML(string));
                    Class<?> clazz3 = object.getClass();
                    Class clazz4 = ReflectionConverter.this.classMapper.lookupDefaultType(clazz);
                    if (!clazz3.equals(clazz4)) {
                        hierarchicalStreamWriter.addAttribute(ReflectionConverter.this.classAttributeIdentifier, ReflectionConverter.this.classMapper.lookupName(clazz3));
                    }
                    if (hashSet.contains(string)) {
                        hierarchicalStreamWriter.addAttribute(ReflectionConverter.this.definedInAttributeIdentifier, ReflectionConverter.this.classMapper.lookupName(clazz2));
                    }
                    marshallingContext.convertAnother(object);
                    hierarchicalStreamWriter.endNode();
                    hashSet.add(string);
                }
            }
        });
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        Object object = unmarshallingContext.currentObject();
        if (object == null) {
            object = this.reflectionProvider.newInstance(unmarshallingContext.getRequiredType());
        }
        while (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            String string = this.classMapper.mapNameFromXML(hierarchicalStreamReader.getNodeName());
            String string2 = hierarchicalStreamReader.getAttribute(this.definedInAttributeIdentifier);
            Class clazz = string2 == null ? null : this.classMapper.lookupType(string2);
            String string3 = hierarchicalStreamReader.getAttribute(this.classAttributeIdentifier);
            Class clazz2 = string3 == null ? this.classMapper.lookupDefaultType(this.reflectionProvider.getFieldType(object, string, clazz)) : this.classMapper.lookupType(string3);
            Object object2 = unmarshallingContext.convertAnother(object, clazz2);
            this.reflectionProvider.writeField(object, string, object2, clazz);
            hierarchicalStreamReader.moveUp();
        }
        return object;
    }
}

