/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.util.ClassStack;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;

public class TreeUnmarshaller
implements UnmarshallingContext {
    private Object root;
    protected HierarchicalStreamReader reader;
    private ConverterLookup converterLookup;
    private ClassMapper classMapper;
    private String classAttributeIdentifier;
    private ClassStack types = new ClassStack(16);

    public TreeUnmarshaller(Object object, HierarchicalStreamReader hierarchicalStreamReader, ConverterLookup converterLookup, ClassMapper classMapper, String string) {
        this.root = object;
        this.reader = hierarchicalStreamReader;
        this.converterLookup = converterLookup;
        this.classMapper = classMapper;
        this.classAttributeIdentifier = string;
    }

    public Object convertAnother(Object object, Class clazz) {
        try {
            Converter converter = this.converterLookup.lookupConverterForType(clazz);
            this.types.push(clazz);
            Object object2 = converter.unmarshal(this.reader, this);
            this.types.popSilently();
            return object2;
        }
        catch (ConversionException conversionException) {
            this.addInformationTo(conversionException, clazz);
            throw conversionException;
        }
        catch (RuntimeException runtimeException) {
            ConversionException conversionException = new ConversionException(runtimeException);
            this.addInformationTo(conversionException, clazz);
            throw conversionException;
        }
    }

    private void addInformationTo(ErrorWriter errorWriter, Class clazz) {
        errorWriter.add("class", clazz.getName());
        errorWriter.add("required-type", this.getRequiredType().getName());
        this.reader.appendErrors(errorWriter);
    }

    public Object currentObject() {
        return this.root;
    }

    public Class getRequiredType() {
        return this.types.peek();
    }

    public Object start() {
        String string = this.reader.getAttribute(this.classAttributeIdentifier);
        Class clazz = string == null ? this.classMapper.lookupType(this.reader.getNodeName()) : this.classMapper.lookupType(string);
        return this.convertAnother(this.root, clazz);
    }
}

