/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import com.thoughtworks.xstream.io.StreamException;
import java.io.IOException;
import java.io.Writer;

public class QuickWriter {
    private final Writer writer;
    private char[] buffer;
    private int pointer;

    public QuickWriter(Writer writer) {
        this.writer = writer;
        this.buffer = new char[32];
    }

    public QuickWriter(Writer writer, int n) {
        this.writer = writer;
        this.buffer = new char[n];
    }

    public void write(String string) {
        int n = string.length();
        if (this.pointer + n >= this.buffer.length) {
            this.flush();
            if (n > this.buffer.length) {
                this.raw(string.toCharArray());
                return;
            }
        }
        string.getChars(0, n, this.buffer, this.pointer);
        this.pointer += n;
    }

    public void write(char c) {
        if (this.pointer + 1 >= this.buffer.length) {
            this.flush();
        }
        this.buffer[this.pointer++] = c;
    }

    public void write(char[] cArray) {
        int n = cArray.length;
        if (this.pointer + n >= this.buffer.length) {
            this.flush();
            if (n > this.buffer.length) {
                this.raw(cArray);
                return;
            }
        }
        System.arraycopy(cArray, 0, this.buffer, this.pointer, n);
        this.pointer += n;
    }

    public void flush() {
        try {
            this.writer.write(this.buffer, 0, this.pointer);
            this.pointer = 0;
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    private void raw(char[] cArray) {
        try {
            this.writer.write(cArray);
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }
}

