/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.path;

import java.util.HashMap;
import java.util.Map;

public class PathTracker {
    private int pointer;
    private int capacity;
    private String[] pathStack;
    private Map[] indexMapStack;
    private String currentPath;

    public PathTracker() {
        this(16);
    }

    public PathTracker(int n) {
        this.capacity = n;
        this.pathStack = new String[this.capacity];
        this.indexMapStack = new Map[this.capacity];
    }

    public void pushElement(String string) {
        if (this.pointer + 1 >= this.capacity) {
            this.resizeStacks(this.capacity * 2);
        }
        this.pathStack[this.pointer] = string;
        HashMap<String, Integer> hashMap = this.indexMapStack[this.pointer];
        if (hashMap == null) {
            this.indexMapStack[this.pointer] = hashMap = new HashMap<String, Integer>();
        }
        if (hashMap.containsKey(string)) {
            hashMap.put(string, new Integer((Integer)hashMap.get(string) + 1));
        } else {
            hashMap.put(string, new Integer(1));
        }
        ++this.pointer;
        this.currentPath = null;
    }

    public void popElement() {
        this.indexMapStack[this.pointer] = null;
        this.currentPath = null;
        --this.pointer;
    }

    public String getCurrentPath() {
        if (this.currentPath == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.pointer; ++i) {
                stringBuffer.append('/');
                stringBuffer.append(this.pathStack[i]);
                Integer n = (Integer)this.indexMapStack[i].get(this.pathStack[i]);
                int n2 = n;
                if (n2 <= 1) continue;
                stringBuffer.append('[').append(n2).append(']');
            }
            this.currentPath = stringBuffer.toString();
        }
        return this.currentPath;
    }

    private void resizeStacks(int n) {
        String[] stringArray = new String[n];
        Map[] mapArray = new Map[n];
        int n2 = Math.min(this.capacity, n);
        System.arraycopy(this.pathStack, 0, stringArray, 0, n2);
        System.arraycopy(this.indexMapStack, 0, mapArray, 0, n2);
        this.pathStack = stringArray;
        this.indexMapStack = mapArray;
        this.capacity = n;
    }
}

