/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

import com.thoughtworks.xstream.core.util.QuickWriter;
import com.thoughtworks.xstream.core.util.StringStack;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class PrettyPrintWriter
implements HierarchicalStreamWriter {
    private final QuickWriter writer;
    private final StringStack elementStack = new StringStack(16);
    private final char[] lineIndenter;
    private boolean tagInProgress;
    private int depth;
    private boolean readyForNewLine;
    private boolean tagIsEmpty;
    private static final char[] AMP = new char[]{'&', 'a', 'm', 'p', ';'};
    private static final char[] LT = new char[]{'&', 'l', 't', ';'};
    private static final char[] GT = new char[]{'&', 'g', 't', ';'};
    private static final char[] CLOSE = new char[]{'<', '/'};

    public PrettyPrintWriter(Writer writer, char[] cArray) {
        this.writer = new QuickWriter(writer);
        this.lineIndenter = cArray;
    }

    public PrettyPrintWriter(Writer writer, String string) {
        this(writer, string.toCharArray());
    }

    public PrettyPrintWriter(PrintWriter printWriter) {
        this((Writer)printWriter, new char[]{' ', ' '});
    }

    public PrettyPrintWriter(Writer writer) {
        this(new PrintWriter(writer));
    }

    public void startNode(String string) {
        this.tagIsEmpty = false;
        this.finishTag();
        this.writer.write('<');
        this.writer.write(string);
        this.elementStack.push(string);
        this.tagInProgress = true;
        ++this.depth;
        this.readyForNewLine = true;
        this.tagIsEmpty = true;
    }

    public void setValue(String string) {
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
        this.finishTag();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        block5: for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            switch (c) {
                case '&': {
                    this.writer.write(AMP);
                    continue block5;
                }
                case '<': {
                    this.writer.write(LT);
                    continue block5;
                }
                case '>': {
                    this.writer.write(GT);
                    continue block5;
                }
                default: {
                    this.writer.write(c);
                }
            }
        }
    }

    public void addAttribute(String string, String string2) {
        this.writer.write(' ');
        this.writer.write(string);
        this.writer.write('=');
        this.writer.write('\"');
        this.writer.write(string2);
        this.writer.write('\"');
    }

    public void endNode() {
        --this.depth;
        if (this.tagIsEmpty) {
            this.writer.write('/');
            this.readyForNewLine = false;
            this.finishTag();
            this.elementStack.popSilently();
        } else {
            this.finishTag();
            this.writer.write(CLOSE);
            this.writer.write(this.elementStack.pop());
            this.writer.write('>');
        }
        this.readyForNewLine = true;
        this.writer.flush();
    }

    private void finishTag() {
        if (this.tagInProgress) {
            this.writer.write('>');
        }
        this.tagInProgress = false;
        if (this.readyForNewLine) {
            this.endOfLine();
        }
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
    }

    protected void endOfLine() {
        this.writer.write('\n');
        for (int i = 0; i < this.depth; ++i) {
            this.writer.write(this.lineIndenter);
        }
    }
}

