/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.alias.ImplicitCollectionDef;
import com.thoughtworks.xstream.alias.ImplicitCollectionMapper;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.SerializationMethodInvoker;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ReflectionConverter
implements Converter {
    private ClassMapper classMapper;
    private String classAttributeIdentifier;
    private String definedInAttributeIdentifier = "defined-in";
    private ReflectionProvider reflectionProvider;
    private ImplicitCollectionMapper implicitCollectionMapper;
    private SerializationMethodInvoker serializationMethodInvoker;

    public ReflectionConverter(ClassMapper classMapper, String classAttributeIdentifier, String definedInAttributeIdentifier, ReflectionProvider reflectionProvider, ImplicitCollectionMapper implicitCollectionMapper) {
        this.classMapper = classMapper;
        this.classAttributeIdentifier = classAttributeIdentifier;
        this.definedInAttributeIdentifier = definedInAttributeIdentifier;
        this.reflectionProvider = reflectionProvider;
        this.implicitCollectionMapper = implicitCollectionMapper;
        this.serializationMethodInvoker = new SerializationMethodInvoker();
    }

    public boolean canConvert(Class type) {
        return true;
    }

    public void marshal(Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        source = this.serializationMethodInvoker.callWriteReplace(source);
        final HashSet seenFields = new HashSet();
        this.reflectionProvider.visitSerializableFields(source, new ReflectionProvider.Visitor(){

            public void visit(String fieldName, Class fieldType, Class definedIn, Object newObj) {
                if (newObj != null) {
                    ImplicitCollectionDef def = ReflectionConverter.this.implicitCollectionMapper.getImplicitCollectionDefForFieldName(definedIn, fieldName);
                    if (def != null) {
                        if (def.getItemFieldName() != null) {
                            ArrayList list = (ArrayList)newObj;
                            Iterator iter = list.iterator();
                            while (iter.hasNext()) {
                                Object obj = iter.next();
                                this.writeField(def.getItemFieldName(), def.getItemType(), definedIn, obj);
                            }
                        } else {
                            context.convertAnother(newObj);
                        }
                    } else {
                        this.writeField(fieldName, fieldType, definedIn, newObj);
                        seenFields.add(fieldName);
                    }
                }
            }

            private void writeField(String fieldName, Class fieldType, Class definedIn, Object newObj) {
                writer.startNode(ReflectionConverter.this.classMapper.mapNameToXML(fieldName));
                Class<?> actualType = newObj.getClass();
                Class defaultType = ReflectionConverter.this.classMapper.lookupDefaultType(fieldType);
                if (!actualType.equals(defaultType)) {
                    writer.addAttribute(ReflectionConverter.this.classAttributeIdentifier, ReflectionConverter.this.classMapper.lookupName(actualType));
                }
                if (seenFields.contains(fieldName)) {
                    writer.addAttribute(ReflectionConverter.this.definedInAttributeIdentifier, ReflectionConverter.this.classMapper.lookupName(definedIn));
                }
                context.convertAnother(newObj);
                writer.endNode();
            }
        });
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Object result = this.instantiateNewInstance(context);
        SeenFields seenFields = new SeenFields();
        Map implicitCollectionsForCurrentObject = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String fieldName = this.classMapper.mapNameFromXML(reader.getNodeName());
            Class classDefiningField = this.determineWhichClassDefinesField(reader);
            boolean fieldExistsInClass = this.reflectionProvider.fieldDefinedInClass(fieldName, result.getClass());
            Class type = this.determineType(reader, fieldExistsInClass, result, fieldName, classDefiningField);
            Object value = context.convertAnother(result, type);
            if (fieldExistsInClass) {
                this.reflectionProvider.writeField(result, fieldName, value, classDefiningField);
                seenFields.add(classDefiningField, fieldName);
            } else {
                implicitCollectionsForCurrentObject = this.writeValueToImplicitCollection(context, value, implicitCollectionsForCurrentObject, result, fieldName);
            }
            reader.moveUp();
        }
        return this.serializationMethodInvoker.callReadResolve(result);
    }

    private Map writeValueToImplicitCollection(UnmarshallingContext context, Object value, Map implicitCollections, Object result, String itemFieldName) {
        String fieldName = this.implicitCollectionMapper.getFieldNameForItemTypeAndName(context.getRequiredType(), value.getClass(), itemFieldName);
        if (fieldName != null) {
            ArrayList<Object> collection;
            if (implicitCollections == null) {
                implicitCollections = new HashMap<String, ArrayList<Object>>();
            }
            if ((collection = (ArrayList<Object>)implicitCollections.get(fieldName)) == null) {
                collection = new ArrayList<Object>();
                this.reflectionProvider.writeField(result, fieldName, collection, null);
                implicitCollections.put(fieldName, collection);
            }
            collection.add(value);
        }
        return implicitCollections;
    }

    private Class determineWhichClassDefinesField(HierarchicalStreamReader reader) {
        String definedIn = reader.getAttribute(this.definedInAttributeIdentifier);
        return definedIn == null ? null : this.classMapper.lookupType(definedIn);
    }

    private Object instantiateNewInstance(UnmarshallingContext context) {
        Object result = context.currentObject();
        if (result == null) {
            result = this.reflectionProvider.newInstance(context.getRequiredType());
        }
        return result;
    }

    private Class determineType(HierarchicalStreamReader reader, boolean validField, Object result, String fieldName, Class definedInCls) {
        String classAttribute = reader.getAttribute(this.classAttributeIdentifier);
        if (classAttribute != null) {
            return this.classMapper.lookupType(classAttribute);
        }
        if (!validField) {
            Class itemType = this.implicitCollectionMapper.getItemTypeForItemFieldName(result.getClass(), fieldName);
            if (itemType != null) {
                return itemType;
            }
            return this.classMapper.lookupType(reader.getNodeName());
        }
        return this.classMapper.lookupDefaultType(this.reflectionProvider.getFieldType(result, fieldName, definedInCls));
    }

    public static class DuplicateFieldException
    extends ConversionException {
        public DuplicateFieldException(String msg) {
            super(msg);
        }
    }

    private static class SeenFields {
        private Set seen = new HashSet();

        private SeenFields() {
        }

        public void add(Class definedInCls, String fieldName) {
            String uniqueKey = fieldName;
            if (definedInCls != null) {
                uniqueKey = uniqueKey + " [" + definedInCls.getName() + "]";
            }
            if (this.seen.contains(uniqueKey)) {
                throw new DuplicateFieldException(uniqueKey);
            }
            this.seen.add(uniqueKey);
        }
    }
}

