/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.SerializationMethodInvoker;
import com.thoughtworks.xstream.core.util.CustomObjectInputStream;
import com.thoughtworks.xstream.core.util.CustomObjectOutputStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SerializableConverter
implements Converter {
    private final SerializationMethodInvoker serializationMethodInvoker = new SerializationMethodInvoker();
    private final ClassMapper classMapper;
    private final ReflectionProvider reflectionProvider;
    private static final String ELEMENT_NULL = "null";
    private static final String ELEMENT_DEFAULT = "default";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_SERIALIZATION = "serialization";
    private static final String ATTRIBUTE_VALUE_CUSTOM = "custom";
    private static final String ELEMENT_FIELDS = "fields";
    private static final String ELEMENT_FIELD = "field";
    private static final String ATTRIBUTE_NAME = "name";
    static /* synthetic */ Class class$java$io$Serializable;

    public SerializableConverter(ClassMapper classMapper, ReflectionProvider reflectionProvider) {
        this.classMapper = classMapper;
        this.reflectionProvider = reflectionProvider;
    }

    public boolean canConvert(Class type) {
        return (class$java$io$Serializable == null ? (class$java$io$Serializable = SerializableConverter.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(type) && (this.serializationMethodInvoker.supportsReadObject(type, true) || this.serializationMethodInvoker.supportsWriteObject(type, true));
    }

    public void marshal(Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        final Object replacedSource = this.serializationMethodInvoker.callWriteReplace(source);
        writer.addAttribute(ATTRIBUTE_SERIALIZATION, ATTRIBUTE_VALUE_CUSTOM);
        final Class[] currentType = new Class[1];
        final boolean[] writtenClassWrapper = new boolean[]{false};
        CustomObjectOutputStream.StreamCallback callback = new CustomObjectOutputStream.StreamCallback(){

            public void writeToStream(Object object) {
                if (object == null) {
                    writer.startNode(SerializableConverter.ELEMENT_NULL);
                    writer.endNode();
                } else {
                    writer.startNode(SerializableConverter.this.classMapper.lookupName(object.getClass()));
                    context.convertAnother(object);
                    writer.endNode();
                }
            }

            public void writeFieldsToStream(Map fields) {
                writer.startNode(SerializableConverter.ELEMENT_FIELDS);
                Iterator iterator = fields.keySet().iterator();
                while (iterator.hasNext()) {
                    String name = (String)iterator.next();
                    Object value = fields.get(name);
                    if (value == null) continue;
                    writer.startNode(SerializableConverter.ELEMENT_FIELD);
                    writer.addAttribute(SerializableConverter.ATTRIBUTE_NAME, name);
                    writer.addAttribute(SerializableConverter.ATTRIBUTE_CLASS, SerializableConverter.this.classMapper.lookupName(value.getClass()));
                    context.convertAnother(value);
                    writer.endNode();
                }
                writer.endNode();
            }

            public void defaultWriteObject() {
                boolean[] writtenDefaultFields = new boolean[]{false};
                SerializableConverter.this.reflectionProvider.visitSerializableFields(replacedSource, new ReflectionProvider.Visitor(this, writtenDefaultFields){
                    private final /* synthetic */ boolean[] val$writtenDefaultFields;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$writtenDefaultFields = val$writtenDefaultFields;
                    }

                    public void visit(String fieldName, Class fieldType, Class definedIn, Object newObj) {
                        if (definedIn == 1.access$100(this.this$1)[0] && newObj != null) {
                            if (!1.access$200(this.this$1)[0]) {
                                1.access$400(this.this$1).startNode(SerializableConverter.access$000(1.access$300(this.this$1)).lookupName(1.access$100(this.this$1)[0]));
                                1.access$200(this.this$1)[0] = true;
                            }
                            if (!this.val$writtenDefaultFields[0]) {
                                1.access$400(this.this$1).startNode("default");
                                this.val$writtenDefaultFields[0] = true;
                            }
                            1.access$400(this.this$1).startNode(SerializableConverter.access$000(1.access$300(this.this$1)).mapNameToXML(fieldName));
                            Class<?> actualType = newObj.getClass();
                            Class defaultType = SerializableConverter.access$000(1.access$300(this.this$1)).lookupDefaultType(fieldType);
                            if (!actualType.equals(defaultType)) {
                                1.access$400(this.this$1).addAttribute("class", SerializableConverter.access$000(1.access$300(this.this$1)).lookupName(actualType));
                            }
                            1.access$500(this.this$1).convertAnother(newObj);
                            1.access$400(this.this$1).endNode();
                        }
                    }
                });
                if (writtenDefaultFields[0]) {
                    writer.endNode();
                }
            }

            public void close() {
                throw new UnsupportedOperationException("Objects are not allowed to call ObjectOutputStream.close() from writeObject()");
            }

            static /* synthetic */ Class[] access$100(1 x0) {
                return x0.currentType;
            }

            static /* synthetic */ boolean[] access$200(1 x0) {
                return x0.writtenClassWrapper;
            }

            static /* synthetic */ SerializableConverter access$300(1 x0) {
                return x0.SerializableConverter.this;
            }

            static /* synthetic */ HierarchicalStreamWriter access$400(1 x0) {
                return x0.writer;
            }

            static /* synthetic */ MarshallingContext access$500(1 x0) {
                return x0.context;
            }
        };
        currentType[0] = replacedSource.getClass();
        while (currentType[0] != null) {
            if (this.serializationMethodInvoker.supportsWriteObject(currentType[0], false)) {
                writtenClassWrapper[0] = true;
                writer.startNode(this.classMapper.lookupName(currentType[0]));
                CustomObjectOutputStream objectOutputStream = CustomObjectOutputStream.getInstance(context, callback);
                this.serializationMethodInvoker.callWriteObject(currentType[0], replacedSource, objectOutputStream);
                writer.endNode();
            } else {
                writtenClassWrapper[0] = false;
                try {
                    callback.defaultWriteObject();
                }
                catch (IOException e) {
                    throw new ObjectAccessException("Could not call defaultWriteObject()", e);
                }
                if (writtenClassWrapper[0]) {
                    writer.endNode();
                }
            }
            currentType[0] = currentType[0].getSuperclass();
        }
    }

    public Object unmarshal(final HierarchicalStreamReader reader, final UnmarshallingContext context) {
        final Object result = this.reflectionProvider.newInstance(context.getRequiredType());
        final Class[] currentType = new Class[1];
        if (!ATTRIBUTE_VALUE_CUSTOM.equals(reader.getAttribute(ATTRIBUTE_SERIALIZATION))) {
            throw new ConversionException("Cannot deserialize object with new readObject()/writeObject() methods");
        }
        CustomObjectInputStream.StreamCallback callback = new CustomObjectInputStream.StreamCallback(){

            public Object readFromStream() {
                reader.moveDown();
                Class type = SerializableConverter.this.classMapper.lookupType(reader.getNodeName());
                Object value = context.convertAnother(result, type);
                reader.moveUp();
                return value;
            }

            public Map readFieldsFromStream() {
                HashMap<String, Object> result2 = new HashMap<String, Object>();
                reader.moveDown();
                if (!reader.getNodeName().equals(SerializableConverter.ELEMENT_FIELDS)) {
                    throw new ConversionException("Expected <fields/> element when calling ObjectInputStream.readFields()");
                }
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    if (!reader.getNodeName().equals(SerializableConverter.ELEMENT_FIELD)) {
                        throw new ConversionException("Expected <field/> element inside <field/>");
                    }
                    String name = reader.getAttribute(SerializableConverter.ATTRIBUTE_NAME);
                    Class type = SerializableConverter.this.classMapper.lookupType(reader.getAttribute(SerializableConverter.ATTRIBUTE_CLASS));
                    Object value = context.convertAnother(result2, type);
                    result2.put(name, value);
                    reader.moveUp();
                }
                reader.moveUp();
                return result2;
            }

            public void defaultReadObject() {
                if (!reader.hasMoreChildren()) {
                    return;
                }
                reader.moveDown();
                if (!reader.getNodeName().equals(SerializableConverter.ELEMENT_DEFAULT)) {
                    throw new ConversionException("Expected <default/> element in readObject() stream");
                }
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    String fieldName = SerializableConverter.this.classMapper.mapNameFromXML(reader.getNodeName());
                    String classAttribute = reader.getAttribute(SerializableConverter.ATTRIBUTE_CLASS);
                    Class type = classAttribute != null ? SerializableConverter.this.classMapper.lookupType(classAttribute) : SerializableConverter.this.classMapper.lookupDefaultType(SerializableConverter.this.reflectionProvider.getFieldType(result, fieldName, currentType[0]));
                    Object value = context.convertAnother(result, type);
                    SerializableConverter.this.reflectionProvider.writeField(result, fieldName, value, currentType[0]);
                    reader.moveUp();
                }
                reader.moveUp();
            }

            public void close() {
                throw new UnsupportedOperationException("Objects are not allowed to call ObjectInputStream.close() from readObject()");
            }
        };
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            currentType[0] = this.classMapper.lookupType(reader.getNodeName());
            if (this.serializationMethodInvoker.supportsReadObject(currentType[0], false)) {
                CustomObjectInputStream objectInputStream = CustomObjectInputStream.getInstance(context, callback);
                this.serializationMethodInvoker.callReadObject(currentType[0], result, objectInputStream);
            } else {
                try {
                    callback.defaultReadObject();
                }
                catch (IOException e) {
                    throw new ObjectAccessException("Could not call defaultWriteObject()", e);
                }
            }
            reader.moveUp();
        }
        return this.serializationMethodInvoker.callReadResolve(result);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

