/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.alias.CannotResolveClassException;
import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.core.util.CompositeClassLoader;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultClassMapper
implements ClassMapper {
    private final ClassLoader classLoader;
    protected final Map typeToNameMap = Collections.synchronizedMap(new HashMap());
    protected final Map nameToTypeMap = Collections.synchronizedMap(new HashMap());
    protected final Map baseTypeToDefaultTypeMap = Collections.synchronizedMap(new HashMap());
    private final Map lookupTypeCache = Collections.synchronizedMap(new HashMap());
    private final Set immutableTypes = Collections.synchronizedSet(new HashSet());
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$com$thoughtworks$xstream$alias$ClassMapper$Null;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy;

    public DefaultClassMapper() {
        this(new CompositeClassLoader());
    }

    public DefaultClassMapper(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.baseTypeToDefaultTypeMap.put(Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultClassMapper.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.baseTypeToDefaultTypeMap.put(Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = DefaultClassMapper.class$("java.lang.Character")) : class$java$lang$Character);
        this.baseTypeToDefaultTypeMap.put(Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultClassMapper.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.baseTypeToDefaultTypeMap.put(Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = DefaultClassMapper.class$("java.lang.Float")) : class$java$lang$Float);
        this.baseTypeToDefaultTypeMap.put(Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = DefaultClassMapper.class$("java.lang.Double")) : class$java$lang$Double);
        this.baseTypeToDefaultTypeMap.put(Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = DefaultClassMapper.class$("java.lang.Short")) : class$java$lang$Short);
        this.baseTypeToDefaultTypeMap.put(Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = DefaultClassMapper.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.baseTypeToDefaultTypeMap.put(Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = DefaultClassMapper.class$("java.lang.Long")) : class$java$lang$Long);
        this.immutableTypes.add(Boolean.TYPE);
        this.immutableTypes.add(class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultClassMapper.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.immutableTypes.add(Byte.TYPE);
        this.immutableTypes.add(class$java$lang$Byte == null ? (class$java$lang$Byte = DefaultClassMapper.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.immutableTypes.add(Character.TYPE);
        this.immutableTypes.add(class$java$lang$Character == null ? (class$java$lang$Character = DefaultClassMapper.class$("java.lang.Character")) : class$java$lang$Character);
        this.immutableTypes.add(Double.TYPE);
        this.immutableTypes.add(class$java$lang$Double == null ? (class$java$lang$Double = DefaultClassMapper.class$("java.lang.Double")) : class$java$lang$Double);
        this.immutableTypes.add(Float.TYPE);
        this.immutableTypes.add(class$java$lang$Float == null ? (class$java$lang$Float = DefaultClassMapper.class$("java.lang.Float")) : class$java$lang$Float);
        this.immutableTypes.add(Integer.TYPE);
        this.immutableTypes.add(class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultClassMapper.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.immutableTypes.add(Long.TYPE);
        this.immutableTypes.add(class$java$lang$Long == null ? (class$java$lang$Long = DefaultClassMapper.class$("java.lang.Long")) : class$java$lang$Long);
        this.immutableTypes.add(Short.TYPE);
        this.immutableTypes.add(class$java$lang$Short == null ? (class$java$lang$Short = DefaultClassMapper.class$("java.lang.Short")) : class$java$lang$Short);
        this.immutableTypes.add(class$com$thoughtworks$xstream$alias$ClassMapper$Null == null ? (class$com$thoughtworks$xstream$alias$ClassMapper$Null = DefaultClassMapper.class$("com.thoughtworks.xstream.alias.ClassMapper$Null")) : class$com$thoughtworks$xstream$alias$ClassMapper$Null);
        this.immutableTypes.add(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DefaultClassMapper.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        this.immutableTypes.add(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DefaultClassMapper.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        this.immutableTypes.add(class$java$lang$String == null ? (class$java$lang$String = DefaultClassMapper.class$("java.lang.String")) : class$java$lang$String);
        this.immutableTypes.add(class$java$net$URL == null ? (class$java$net$URL = DefaultClassMapper.class$("java.net.URL")) : class$java$net$URL);
        this.immutableTypes.add(class$java$io$File == null ? (class$java$io$File = DefaultClassMapper.class$("java.io.File")) : class$java$io$File);
        this.immutableTypes.add(class$java$lang$Class == null ? (class$java$lang$Class = DefaultClassMapper.class$("java.lang.Class")) : class$java$lang$Class);
    }

    public String mapNameToXML(String javaName) {
        StringBuffer result = new StringBuffer();
        int length = javaName.length();
        for (int i = 0; i < length; ++i) {
            char c = javaName.charAt(i);
            if (c == '$') {
                result.append("_DOLLAR_");
                continue;
            }
            if (c == '_') {
                result.append("__");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public String mapNameFromXML(String xmlName) {
        StringBuffer result = new StringBuffer();
        int length = xmlName.length();
        for (int i = 0; i < length; ++i) {
            char c = xmlName.charAt(i);
            if (c == '_') {
                if (xmlName.charAt(i + 1) == '_') {
                    ++i;
                    result.append('_');
                    continue;
                }
                if (xmlName.length() < i + 8 || !xmlName.substring(i + 1, i + 8).equals("DOLLAR_")) continue;
                i += 7;
                result.append('$');
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public void alias(String elementName, Class type, Class defaultImplementation) {
        this.nameToTypeMap.put(elementName, type.getName());
        this.typeToNameMap.put(type, elementName);
        if (!type.equals(defaultImplementation)) {
            this.typeToNameMap.put(defaultImplementation, elementName);
        }
        this.baseTypeToDefaultTypeMap.put(type, defaultImplementation);
    }

    public String lookupName(Class type) {
        StringBuffer arraySuffix = new StringBuffer();
        while (type.isArray()) {
            type = type.getComponentType();
            arraySuffix.append("-array");
        }
        String result = (String)this.typeToNameMap.get(type);
        if (result == null && Proxy.isProxyClass(type)) {
            result = (String)this.typeToNameMap.get(class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy == null ? (class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy = DefaultClassMapper.class$("com.thoughtworks.xstream.alias.ClassMapper$DynamicProxy")) : class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy);
        }
        if (result == null && (result = type.getName().replace('$', '-')).charAt(0) == '-') {
            result = "default" + result;
        }
        if (arraySuffix.length() > 0) {
            result = result + arraySuffix.toString();
        }
        return result;
    }

    private Class primitiveClassNamed(String name) {
        return name.equals("void") ? Void.TYPE : (name.equals("boolean") ? Boolean.TYPE : (name.equals("byte") ? Byte.TYPE : (name.equals("char") ? Character.TYPE : (name.equals("short") ? Short.TYPE : (name.equals("int") ? Integer.TYPE : (name.equals("long") ? Long.TYPE : (name.equals("float") ? Float.TYPE : (name.equals("double") ? Double.TYPE : null))))))));
    }

    public Class lookupType(String elementName) {
        Class<?> result;
        String key = elementName;
        if (elementName.equals("null")) {
            return null;
        }
        if (this.lookupTypeCache.containsKey(key)) {
            return (Class)this.lookupTypeCache.get(key);
        }
        int arrayDepth = 0;
        while (elementName.endsWith("-array")) {
            elementName = elementName.substring(0, elementName.length() - 6);
            ++arrayDepth;
        }
        Class primvCls = null;
        if (arrayDepth > 0) {
            primvCls = this.primitiveClassNamed(elementName);
        }
        String mappedName = null;
        if (primvCls == null) {
            mappedName = (String)this.nameToTypeMap.get(this.mapNameFromXML(elementName));
        }
        if (mappedName != null) {
            elementName = mappedName;
        }
        if ((elementName = elementName.replace('-', '$')).startsWith("default$")) {
            elementName = elementName.substring(7);
        }
        try {
            if (arrayDepth > 0) {
                if (primvCls != null) {
                    StringBuffer className = new StringBuffer();
                    for (int i = 0; i < arrayDepth; ++i) {
                        className.append('[');
                    }
                    className.append(this.charThatJavaUsesToRepresentPrimitiveType(primvCls));
                    result = this.classLoader.loadClass(className.toString());
                } else {
                    StringBuffer className = new StringBuffer();
                    for (int i = 0; i < arrayDepth; ++i) {
                        className.append('[');
                    }
                    className.append('L').append(elementName).append(';');
                    result = this.classLoader.loadClass(className.toString());
                }
            } else {
                result = this.classLoader.loadClass(elementName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new CannotResolveClassException(elementName + " : " + e.getMessage());
        }
        this.lookupTypeCache.put(key, result);
        return result;
    }

    private char charThatJavaUsesToRepresentPrimitiveType(Class primvCls) {
        return (char)(primvCls == Boolean.TYPE ? 90 : (primvCls == Byte.TYPE ? 66 : (primvCls == Character.TYPE ? 67 : (primvCls == Short.TYPE ? 83 : (primvCls == Integer.TYPE ? 73 : (primvCls == Long.TYPE ? 74 : (primvCls == Float.TYPE ? 70 : (primvCls == Double.TYPE ? 68 : 0))))))));
    }

    public Class lookupDefaultType(Class baseType) {
        Class result = (Class)this.baseTypeToDefaultTypeMap.get(baseType);
        return result == null ? baseType : result;
    }

    public boolean isImmutableValueType(Class type) {
        return this.immutableTypes.contains(type);
    }

    public void addImmutableType(Class type) {
        this.immutableTypes.add(type);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

