/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.core.TreeUnmarshaller;
import com.thoughtworks.xstream.core.util.FastStack;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.util.HashMap;
import java.util.Map;

public class ReferenceByIdUnmarshaller
extends TreeUnmarshaller {
    private Map values = new HashMap();
    private FastStack parentIdStack = new FastStack(16);

    public ReferenceByIdUnmarshaller(Object root, HierarchicalStreamReader reader, ConverterLookup converterLookup, ClassMapper classMapper, String classAttributeIdentifier) {
        super(root, reader, converterLookup, classMapper, classAttributeIdentifier);
    }

    public Object convertAnother(Object parent, Class type) {
        String reference;
        if (this.parentIdStack.size() > 0) {
            this.values.put(this.parentIdStack.peek(), parent);
        }
        if ((reference = this.reader.getAttribute("reference")) != null) {
            return this.values.get(reference);
        }
        String currentId = this.reader.getAttribute("id");
        this.parentIdStack.push(currentId);
        Object result = super.convertAnother(parent, type);
        this.values.put(currentId, result);
        this.parentIdStack.popSilently();
        return result;
    }
}

