/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.collections;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.collections.TreeMapConverter;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.core.util.PresortedSet;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class TreeSetConverter
extends CollectionConverter {
    private transient TreeMapConverter treeMapConverter;
    private static final Field sortedMapField;
    static /* synthetic */ Class class$java$util$TreeSet;
    static /* synthetic */ Class class$java$util$SortedMap;

    public TreeSetConverter(Mapper mapper) {
        super(mapper);
        this.readResolve();
    }

    public boolean canConvert(Class type) {
        return type.equals(class$java$util$TreeSet == null ? (class$java$util$TreeSet = TreeSetConverter.class$("java.util.TreeSet")) : class$java$util$TreeSet);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        TreeSet treeSet = (TreeSet)source;
        this.treeMapConverter.marshalComparator(treeSet.comparator(), writer, context);
        super.marshal(source, writer, context);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        TreeMap treeMap;
        Comparator comparator;
        TreeSet result = null;
        Comparator unmarshalledComparator = this.treeMapConverter.unmarshalComparator(reader, context, null);
        boolean inFirstElement = unmarshalledComparator instanceof Mapper.Null;
        Comparator comparator2 = comparator = inFirstElement ? null : unmarshalledComparator;
        if (sortedMapField != null) {
            TreeSet possibleResult = comparator == null ? new TreeSet() : new TreeSet(comparator);
            Object backingMap = null;
            try {
                backingMap = sortedMapField.get(possibleResult);
            }
            catch (IllegalAccessException e) {
                throw new ConversionException("Cannot get backing map of TreeSet", e);
            }
            if (backingMap instanceof TreeMap) {
                treeMap = (TreeMap)backingMap;
                result = possibleResult;
            } else {
                treeMap = null;
            }
        } else {
            treeMap = null;
        }
        if (treeMap == null) {
            PresortedSet set = new PresortedSet(comparator);
            TreeSet treeSet = result = comparator == null ? new TreeSet() : new TreeSet(comparator);
            if (inFirstElement) {
                this.addCurrentElementToCollection(reader, context, result, set);
                reader.moveUp();
            }
            this.populateCollection(reader, context, result, set);
            if (set.size() > 0) {
                result.addAll(set);
            }
        } else {
            this.treeMapConverter.populateTreeMap(reader, context, treeMap, unmarshalledComparator);
        }
        return result;
    }

    private Object readResolve() {
        this.treeMapConverter = new TreeMapConverter(this.mapper()){

            protected void populateMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map, final Map target) {
                TreeSetConverter.this.populateCollection(reader, context, new AbstractList(){

                    public boolean add(Object object) {
                        return target.put(object, object) != null;
                    }

                    public Object get(int location) {
                        return null;
                    }

                    public int size() {
                        return target.size();
                    }
                });
            }

            protected void putCurrentEntryIntoMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map, Map target) {
                Object key = this.readItem(reader, context, map);
                target.put(key, key);
            }
        };
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Field smField = null;
        if (!JVM.hasOptimizedTreeSetAddAll()) {
            try {
                Field[] fields = (class$java$util$TreeSet == null ? (class$java$util$TreeSet = TreeSetConverter.class$("java.util.TreeSet")) : class$java$util$TreeSet).getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    if (!(class$java$util$SortedMap == null ? TreeSetConverter.class$("java.util.SortedMap") : class$java$util$SortedMap).isAssignableFrom(fields[i].getType())) continue;
                    smField = fields[i];
                    smField.setAccessible(true);
                    break;
                }
                if (smField == null) {
                    throw new ExceptionInInitializerError("Cannot detect field of backing map of TreeSet");
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        sortedMapField = smField;
    }
}

