/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.tools.benchmark.metrics;

import com.thoughtworks.xstream.tools.benchmark.Metric;
import com.thoughtworks.xstream.tools.benchmark.Product;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class DeserializationSpeedMetric
implements Metric {
    private int iterations;

    public DeserializationSpeedMetric(int iterations) {
        this.iterations = iterations;
    }

    public double run(Product product, Object object) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        product.serialize(object, output);
        byte[] data = output.toByteArray();
        product.deserialize(new ByteArrayInputStream(data));
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.iterations; ++i) {
            product.deserialize(new ByteArrayInputStream(data));
        }
        long end = System.currentTimeMillis();
        return end - start;
    }

    public String unit() {
        return "ms";
    }

    public boolean biggerIsBetter() {
        return false;
    }

    public String toString() {
        return "Deserialization speed (" + this.iterations + " iteration" + (this.iterations == 1 ? "" : "s") + ")";
    }
}

