/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.tools.benchmark;

import com.thoughtworks.xstream.tools.benchmark.Metric;
import com.thoughtworks.xstream.tools.benchmark.Product;
import com.thoughtworks.xstream.tools.benchmark.Reporter;
import com.thoughtworks.xstream.tools.benchmark.Target;
import java.util.ArrayList;
import java.util.List;

public class Harness {
    private List products = new ArrayList();
    private List targets = new ArrayList();
    private List metrics = new ArrayList();

    public synchronized void addProduct(Product product) {
        this.products.add(product);
    }

    public synchronized void addTarget(Target target) {
        this.targets.add(target);
    }

    public synchronized void addMetric(Metric metric) {
        this.metrics.add(metric);
    }

    public synchronized void run(Reporter reporter) {
        reporter.startBenchmark();
        for (Metric metric : this.metrics) {
            reporter.startMetric(metric);
            for (Target target : this.targets) {
                reporter.startTarget(target);
                for (Product product : this.products) {
                    this.run(reporter, metric, target, product);
                }
                reporter.endTarget(target);
            }
            reporter.endMetric(metric);
        }
        reporter.endBenchmark();
    }

    private void run(Reporter reporter, Metric metric, Target target, Product product) {
        try {
            double result = metric.run(product, target);
            reporter.metricRecorded(product, result);
        }
        catch (Exception e) {
            reporter.metricFailed(product, e);
        }
    }
}

