/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.tools.benchmark.metrics;

import com.thoughtworks.xstream.tools.benchmark.Metric;
import com.thoughtworks.xstream.tools.benchmark.Product;
import com.thoughtworks.xstream.tools.benchmark.Target;
import java.io.ByteArrayOutputStream;

public class SerializationSpeedMetric
implements Metric {
    private int iterations;

    public SerializationSpeedMetric(int iterations) {
        this.iterations = iterations;
    }

    public double run(Product product, Target target) throws Exception {
        return this.run(product, target.target());
    }

    public double run(Product product, Object object) throws Exception {
        product.serialize(object, new ByteArrayOutputStream());
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.iterations; ++i) {
            product.serialize(object, new ByteArrayOutputStream());
        }
        long end = System.currentTimeMillis();
        return end - start;
    }

    public String unit() {
        return "ms";
    }

    public boolean biggerIsBetter() {
        return false;
    }

    public String toString() {
        return "Serialization speed (" + this.iterations + " iteration" + (this.iterations == 1 ? "" : "s") + ")";
    }
}

