/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.StatsDClient;
import com.timgroup.statsd.StatsDClientErrorHandler;
import com.timgroup.statsd.StatsDClientException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class NonBlockingStatsDClient
implements StatsDClient {
    private static final StatsDClientErrorHandler NO_OP_HANDLER = new StatsDClientErrorHandler(){

        @Override
        public void handle(Exception exception) {
        }
    };
    private final String prefix;
    private final DatagramSocket clientSocket;
    private final StatsDClientErrorHandler handler;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){
        final ThreadFactory delegate = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = this.delegate.newThread(runnable);
            thread.setName("StatsD-" + thread.getName());
            return thread;
        }
    });

    public NonBlockingStatsDClient(String string, String string2, int n) throws StatsDClientException {
        this(string, string2, n, NO_OP_HANDLER);
    }

    public NonBlockingStatsDClient(String string, String string2, int n, StatsDClientErrorHandler statsDClientErrorHandler) throws StatsDClientException {
        this.prefix = string;
        this.handler = statsDClientErrorHandler;
        try {
            this.clientSocket = new DatagramSocket();
            this.clientSocket.connect(new InetSocketAddress(string2, n));
        }
        catch (Exception exception) {
            throw new StatsDClientException("Failed to start StatsD client", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            this.handler.handle(exception);
        }
        finally {
            if (this.clientSocket != null) {
                this.clientSocket.close();
            }
        }
    }

    @Override
    public void count(String string, int n) {
        this.send(String.format("%s.%s:%d|c", this.prefix, string, n));
    }

    @Override
    public void incrementCounter(String string) {
        this.count(string, 1);
    }

    @Override
    public void increment(String string) {
        this.incrementCounter(string);
    }

    @Override
    public void decrementCounter(String string) {
        this.count(string, -1);
    }

    @Override
    public void decrement(String string) {
        this.decrementCounter(string);
    }

    @Override
    public void recordGaugeValue(String string, int n) {
        this.send(String.format("%s.%s:%d|g", this.prefix, string, n));
    }

    @Override
    public void gauge(String string, int n) {
        this.recordGaugeValue(string, n);
    }

    @Override
    public void recordExecutionTime(String string, int n) {
        this.send(String.format("%s.%s:%d|ms", this.prefix, string, n));
    }

    @Override
    public void time(String string, int n) {
        this.recordExecutionTime(string, n);
    }

    private void send(final String string) {
        try {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    NonBlockingStatsDClient.this.blockingSend(string);
                }
            });
        }
        catch (Exception exception) {
            this.handler.handle(exception);
        }
    }

    private void blockingSend(String string) {
        try {
            byte[] byArray = string.getBytes();
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            this.clientSocket.send(datagramPacket);
        }
        catch (Exception exception) {
            this.handler.handle(exception);
        }
    }
}

