/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.ConvenienceMethodProvidingStatsDClient;
import com.timgroup.statsd.NonBlockingUdpSender;
import com.timgroup.statsd.StatsDClientErrorHandler;
import com.timgroup.statsd.StatsDClientException;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.Locale;

public final class NonBlockingStatsDClient
extends ConvenienceMethodProvidingStatsDClient {
    private static final Charset STATS_D_ENCODING = Charset.forName("UTF-8");
    private static final StatsDClientErrorHandler NO_OP_HANDLER = new StatsDClientErrorHandler(){

        @Override
        public void handle(Exception exception) {
        }
    };
    private final String prefix;
    private final NonBlockingUdpSender sender;

    public NonBlockingStatsDClient(String string, String string2, int n) throws StatsDClientException {
        this(string, string2, n, NO_OP_HANDLER);
    }

    public NonBlockingStatsDClient(String string, String string2, int n, StatsDClientErrorHandler statsDClientErrorHandler) throws StatsDClientException {
        this.prefix = string == null || string.trim().isEmpty() ? "" : string.trim() + ".";
        try {
            this.sender = new NonBlockingUdpSender(string2, n, STATS_D_ENCODING, statsDClientErrorHandler);
        }
        catch (Exception exception) {
            throw new StatsDClientException("Failed to start StatsD client", exception);
        }
    }

    @Override
    public void stop() {
        this.sender.stop();
    }

    @Override
    public void count(String string, long l, double d) {
        this.send(this.messageFor(string, Long.toString(l), "c", d));
    }

    @Override
    public void recordGaugeValue(String string, long l) {
        this.recordGaugeCommon(string, Long.toString(l), l < 0L, false);
    }

    @Override
    public void recordGaugeValue(String string, double d) {
        this.recordGaugeCommon(string, this.stringValueOf(d), d < 0.0, false);
    }

    @Override
    public void recordGaugeDelta(String string, long l) {
        this.recordGaugeCommon(string, Long.toString(l), l < 0L, true);
    }

    @Override
    public void recordGaugeDelta(String string, double d) {
        this.recordGaugeCommon(string, this.stringValueOf(d), d < 0.0, true);
    }

    private void recordGaugeCommon(String string, String string2, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl2 && bl) {
            stringBuilder.append(this.messageFor(string, "0", "g")).append('\n');
        }
        stringBuilder.append(this.messageFor(string, bl2 && !bl ? "+" + string2 : string2, "g"));
        this.send(stringBuilder.toString());
    }

    @Override
    public void recordSetEvent(String string, String string2) {
        this.send(this.messageFor(string, string2, "s"));
    }

    @Override
    public void recordExecutionTime(String string, long l, double d) {
        this.send(this.messageFor(string, Long.toString(l), "ms", d));
    }

    private String messageFor(String string, String string2, String string3) {
        return this.messageFor(string, string2, string3, 1.0);
    }

    private String messageFor(String string, String string2, String string3, double d) {
        String string4 = this.prefix + string + ':' + string2 + '|' + string3;
        return d == 1.0 ? string4 : string4 + "|@" + this.stringValueOf(d);
    }

    private void send(String string) {
        this.sender.send(string);
    }

    private String stringValueOf(double d) {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(19);
        return numberFormat.format(d);
    }
}

