/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.StatsDClientErrorHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class NonBlockingUdpSender {
    private final Charset encoding;
    private final DatagramChannel clientSocket;
    private final ExecutorService executor;
    private StatsDClientErrorHandler handler;

    public NonBlockingUdpSender(String string, int n, Charset charset, StatsDClientErrorHandler statsDClientErrorHandler) throws IOException {
        this.encoding = charset;
        this.handler = statsDClientErrorHandler;
        this.clientSocket = DatagramChannel.open();
        this.clientSocket.connect(new InetSocketAddress(string, n));
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){
            final ThreadFactory delegate = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = this.delegate.newThread(runnable);
                thread.setName("StatsD-" + thread.getName());
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            this.handler.handle(exception);
        }
        finally {
            if (this.clientSocket != null) {
                try {
                    this.clientSocket.close();
                }
                catch (Exception exception) {
                    this.handler.handle(exception);
                }
            }
        }
    }

    public void send(final String string) {
        try {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    NonBlockingUdpSender.this.blockingSend(string);
                }
            });
        }
        catch (Exception exception) {
            this.handler.handle(exception);
        }
    }

    private void blockingSend(String string) {
        try {
            byte[] byArray = string.getBytes(this.encoding);
            this.clientSocket.write(ByteBuffer.wrap(byArray));
        }
        catch (Exception exception) {
            this.handler.handle(exception);
        }
    }
}

