/*
 * Decompiled with CFR 0.152.
 */
package com.tocea.easycoverage.framework.junit;

import com.tocea.easycoverage.framework.api.IEasycoverageChecker;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

public class EasycoverageTestCase
extends TestCase {
    private final IEasycoverageChecker checker;
    private final ExecutorService executorService;
    private final int timeout;

    public EasycoverageTestCase(IEasycoverageChecker checker, ExecutorService executorService, int timeout) {
        this.checker = checker;
        this.executorService = executorService;
        this.timeout = timeout;
        this.setName(checker.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TestResult result) {
        result.startTest((Test)this);
        Future<?> future = this.executorService.submit(new TestTask());
        try {
            if (this.timeout > 0) {
                future.get(this.timeout, TimeUnit.MILLISECONDS);
            } else {
                future.get();
            }
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            result.addError((Test)this, e.getCause());
        }
        catch (TimeoutException e) {
            if (future != null && !future.isDone() && !future.isCancelled()) {
                future.cancel(true);
            }
            result.addError((Test)this, (Throwable)new Exception(this.getName() + " has timed out after " + this.timeout + "ms.", e));
        }
        finally {
            result.endTest((Test)this);
        }
    }

    private class TestTask
    implements Runnable {
        private TestTask() {
        }

        public void run() {
            EasycoverageTestCase.this.checker.check();
        }
    }
}

