/*
 * Decompiled with CFR 0.152.
 */
package com.tocea.easycoverage.framework.junit;

import com.tocea.easycoverage.framework.CheckersRunner;
import com.tocea.easycoverage.framework.ClassChecker;
import com.tocea.easycoverage.framework.MethodChecker;
import com.tocea.easycoverage.framework.api.IEasycoverageChecker;
import com.tocea.easycoverage.framework.api.IInstanceProvider;
import com.tocea.easycoverage.framework.junit.EasycoverageTestCase;
import com.tocea.easycoverage.framework.utils.Utils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import junit.framework.Test;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitTestSuiteProvider {
    private int timeout = 0;
    private final CheckersRunner runner = new CheckersRunner();

    public TestSuite getTestSuite() {
        return this.getTestSuite("Easycoverage Test Suite");
    }

    public TestSuite getTestSuite(String name) {
        TestSuite suite = new TestSuite(name);
        ExecutorService executorService = Executors.newCachedThreadPool();
        for (Class<?> clazz : this.getClasses()) {
            TestSuite classSuite = new TestSuite(clazz.getName());
            for (ClassChecker checker : this.runner.getCheckers(clazz)) {
                classSuite.addTest((Test)new EasycoverageTestCase((IEasycoverageChecker)checker, executorService, this.timeout));
            }
            for (Method method : Utils.getDeclaredPublicMethods(clazz)) {
                TestSuite methodSuite = new TestSuite(Utils.getQualifiedName((Method)method).replace('(', '[').replace(')', ']'));
                for (MethodChecker checker : this.runner.getCheckers(method)) {
                    methodSuite.addTest((Test)new EasycoverageTestCase((IEasycoverageChecker)checker, executorService, this.timeout));
                }
                if (methodSuite.countTestCases() <= 0) continue;
                classSuite.addTest((Test)methodSuite);
            }
            if (classSuite.countTestCases() <= 0) continue;
            suite.addTest((Test)classSuite);
        }
        return suite;
    }

    public IInstanceProvider getProvider() {
        return this.runner.getProvider();
    }

    public void setProvider(IInstanceProvider provider) {
        this.runner.setProvider(provider);
    }

    public Set<Class<?>> getClasses() {
        return this.runner.getClasses();
    }

    public void addClass(Class<?> clazz) {
        this.runner.addClass(clazz);
    }

    public void addClasses(Collection<Class<?>> classes) {
        this.runner.addClasses(classes);
    }

    @Deprecated
    public void setClasses(Set<Class<?>> classes) {
        this.runner.addClasses(classes);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Set<Class<? extends ClassChecker>> getClassCheckers() {
        return this.runner.getClassCheckers();
    }

    public void addClassChecker(Class<? extends ClassChecker> checker) {
        this.runner.addClassChecker(checker);
    }

    public void addClassCheckers(Collection<Class<? extends ClassChecker>> checkers) {
        this.runner.addClassCheckers(checkers);
    }

    @Deprecated
    public void setClassCheckers(Set<Class<? extends ClassChecker>> classCheckers) {
        this.addClassCheckers(classCheckers);
    }

    public Set<Class<? extends MethodChecker>> getMethodCheckers() {
        return this.runner.getMethodCheckers();
    }

    public void addMethodChecker(Class<? extends MethodChecker> checker) {
        this.runner.addMethodChecker(checker);
    }

    public void addMethodCheckers(Collection<Class<? extends MethodChecker>> checkers) {
        this.runner.addMethodCheckers(checkers);
    }

    @Deprecated
    public void setMethodCheckers(Set<Class<? extends MethodChecker>> methodCheckers) {
        this.runner.addMethodCheckers(methodCheckers);
    }
}

