/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.accounts.v1.credential;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import org.joda.time.DateTime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class PublicKey extends Resource {
    private static final long serialVersionUID = 108884981918794L;

    /**
     * Create a PublicKeyReader to execute read.
     * 
     * @return PublicKeyReader capable of executing the read
     */
    public static PublicKeyReader reader() {
        return new PublicKeyReader();
    }

    /**
     * Create a PublicKeyCreator to execute create.
     * 
     * @param publicKey URL encoded representation of the public key
     * @return PublicKeyCreator capable of executing the create
     */
    public static PublicKeyCreator creator(final String publicKey) {
        return new PublicKeyCreator(publicKey);
    }

    /**
     * Create a PublicKeyFetcher to execute fetch.
     * 
     * @param pathSid Fetch by unique Credential Sid
     * @return PublicKeyFetcher capable of executing the fetch
     */
    public static PublicKeyFetcher fetcher(final String pathSid) {
        return new PublicKeyFetcher(pathSid);
    }

    /**
     * Create a PublicKeyUpdater to execute update.
     * 
     * @param pathSid Fetch by unique Credential Sid
     * @return PublicKeyUpdater capable of executing the update
     */
    public static PublicKeyUpdater updater(final String pathSid) {
        return new PublicKeyUpdater(pathSid);
    }

    /**
     * Create a PublicKeyDeleter to execute delete.
     * 
     * @param pathSid A 34 character string that uniquely identifies this resource.
     * @return PublicKeyDeleter capable of executing the delete
     */
    public static PublicKeyDeleter deleter(final String pathSid) {
        return new PublicKeyDeleter(pathSid);
    }

    /**
     * Converts a JSON String into a PublicKey object using the provided
     * ObjectMapper.
     * 
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return PublicKey object represented by the provided JSON
     */
    public static PublicKey fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, PublicKey.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a PublicKey object using the provided
     * ObjectMapper.
     * 
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return PublicKey object represented by the provided JSON
     */
    public static PublicKey fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, PublicKey.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    @JsonCreator
    private PublicKey(@JsonProperty("sid")
                      final String sid, 
                      @JsonProperty("account_sid")
                      final String accountSid, 
                      @JsonProperty("friendly_name")
                      final String friendlyName, 
                      @JsonProperty("date_created")
                      final String dateCreated, 
                      @JsonProperty("date_updated")
                      final String dateUpdated, 
                      @JsonProperty("url")
                      final URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    /**
     * Returns The A 34 character string that uniquely identifies this resource..
     * 
     * @return A 34 character string that uniquely identifies this resource.
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The AccountSid the Credential resource belongs to.
     * 
     * @return AccountSid the Credential resource belongs to
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The A human readable description of this resource.
     * 
     * @return A human readable description of this resource
     */
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    /**
     * Returns The The date this resource was created.
     * 
     * @return The date this resource was created
     */
    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The The date this resource was last updated.
     * 
     * @return The date this resource was last updated
     */
    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The The URI for this resource, relative to
     * `https://accounts.twilio.com`.
     * 
     * @return The URI for this resource, relative to `https://accounts.twilio.com`
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        PublicKey other = (PublicKey) o;

        return Objects.equals(sid, other.sid) && 
               Objects.equals(accountSid, other.accountSid) && 
               Objects.equals(friendlyName, other.friendlyName) && 
               Objects.equals(dateCreated, other.dateCreated) && 
               Objects.equals(dateUpdated, other.dateUpdated) && 
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            accountSid,
                            friendlyName,
                            dateCreated,
                            dateUpdated,
                            url);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                          .add("sid", sid)
                          .add("accountSid", accountSid)
                          .add("friendlyName", friendlyName)
                          .add("dateCreated", dateCreated)
                          .add("dateUpdated", dateUpdated)
                          .add("url", url)
                          .toString();
    }
}