/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class AddressUpdater extends Updater<Address> {
    private String pathAccountSid;
    private final String pathSid;
    private String friendlyName;
    private String customerName;
    private String street;
    private String city;
    private String region;
    private String postalCode;
    private Boolean emergencyEnabled;
    private Boolean autoCorrectAddress;

    /**
     * Construct a new AddressUpdater.
     * 
     * @param pathSid The sid
     */
    public AddressUpdater(final String pathSid) {
        this.pathSid = pathSid;
    }

    /**
     * Construct a new AddressUpdater.
     * 
     * @param pathAccountSid The account_sid
     * @param pathSid The sid
     */
    public AddressUpdater(final String pathAccountSid, 
                          final String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathSid = pathSid;
    }

    /**
     * The friendly_name.
     * 
     * @param friendlyName The friendly_name
     * @return this
     */
    public AddressUpdater setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    /**
     * The customer_name.
     * 
     * @param customerName The customer_name
     * @return this
     */
    public AddressUpdater setCustomerName(final String customerName) {
        this.customerName = customerName;
        return this;
    }

    /**
     * The street.
     * 
     * @param street The street
     * @return this
     */
    public AddressUpdater setStreet(final String street) {
        this.street = street;
        return this;
    }

    /**
     * The city.
     * 
     * @param city The city
     * @return this
     */
    public AddressUpdater setCity(final String city) {
        this.city = city;
        return this;
    }

    /**
     * The region.
     * 
     * @param region The region
     * @return this
     */
    public AddressUpdater setRegion(final String region) {
        this.region = region;
        return this;
    }

    /**
     * The postal_code.
     * 
     * @param postalCode The postal_code
     * @return this
     */
    public AddressUpdater setPostalCode(final String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    /**
     * The emergency_enabled.
     * 
     * @param emergencyEnabled The emergency_enabled
     * @return this
     */
    public AddressUpdater setEmergencyEnabled(final Boolean emergencyEnabled) {
        this.emergencyEnabled = emergencyEnabled;
        return this;
    }

    /**
     * The auto_correct_address.
     * 
     * @param autoCorrectAddress The auto_correct_address
     * @return this
     */
    public AddressUpdater setAutoCorrectAddress(final Boolean autoCorrectAddress) {
        this.autoCorrectAddress = autoCorrectAddress;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return Updated Address
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Address update(final TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(
            HttpMethod.POST,
            Domains.API.toString(),
            "/2010-04-01/Accounts/" + this.pathAccountSid + "/Addresses/" + this.pathSid + ".json",
            client.getRegion()
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Address update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }

            throw new ApiException(
                restException.getMessage(),
                restException.getCode(),
                restException.getMoreInfo(),
                restException.getStatus(),
                null
            );
        }

        return Address.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     * 
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (customerName != null) {
            request.addPostParam("CustomerName", customerName);
        }

        if (street != null) {
            request.addPostParam("Street", street);
        }

        if (city != null) {
            request.addPostParam("City", city);
        }

        if (region != null) {
            request.addPostParam("Region", region);
        }

        if (postalCode != null) {
            request.addPostParam("PostalCode", postalCode);
        }

        if (emergencyEnabled != null) {
            request.addPostParam("EmergencyEnabled", emergencyEnabled.toString());
        }

        if (autoCorrectAddress != null) {
            request.addPostParam("AutoCorrectAddress", autoCorrectAddress.toString());
        }
    }
}