/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.net.URI;

public class IncomingPhoneNumberUpdater extends Updater<IncomingPhoneNumber> {
    private String pathAccountSid;
    private final String pathSid;
    private String accountSid;
    private String apiVersion;
    private String friendlyName;
    private String smsApplicationSid;
    private HttpMethod smsFallbackMethod;
    private URI smsFallbackUrl;
    private HttpMethod smsMethod;
    private URI smsUrl;
    private URI statusCallback;
    private HttpMethod statusCallbackMethod;
    private String voiceApplicationSid;
    private Boolean voiceCallerIdLookup;
    private HttpMethod voiceFallbackMethod;
    private URI voiceFallbackUrl;
    private HttpMethod voiceMethod;
    private URI voiceUrl;
    private IncomingPhoneNumber.EmergencyStatus emergencyStatus;
    private String emergencyAddressSid;
    private String trunkSid;
    private IncomingPhoneNumber.VoiceReceiveMode voiceReceiveMode;
    private String identitySid;
    private String addressSid;

    /**
     * Construct a new IncomingPhoneNumberUpdater.
     * 
     * @param pathSid The sid
     */
    public IncomingPhoneNumberUpdater(final String pathSid) {
        this.pathSid = pathSid;
    }

    /**
     * Construct a new IncomingPhoneNumberUpdater.
     * 
     * @param pathAccountSid The new owner of the phone number
     * @param pathSid The sid
     */
    public IncomingPhoneNumberUpdater(final String pathAccountSid, 
                                      final String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathSid = pathSid;
    }

    /**
     * The unique id of the Account to which you wish to transfer this phone number.
     * 
     * @param accountSid The new owner of the phone number
     * @return this
     */
    public IncomingPhoneNumberUpdater setAccountSid(final String accountSid) {
        this.accountSid = accountSid;
        return this;
    }

    /**
     * Calls to this phone number will start a new TwiML session with this API
     * version..
     * 
     * @param apiVersion The Twilio REST API version to use
     * @return this
     */
    public IncomingPhoneNumberUpdater setApiVersion(final String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    /**
     * A human readable descriptive text for this resource, up to 64 characters
     * long. By default, the `FriendlyName` is a nicely formatted version of the
     * phone number..
     * 
     * @param friendlyName A human readable description of this resource
     * @return this
     */
    public IncomingPhoneNumberUpdater setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    /**
     * The 34 character sid of the application Twilio should use to handle SMSs sent
     * to this number. If a `SmsApplicationSid` is present, Twilio will ignore all
     * of the SMS urls above and use those set on the application..
     * 
     * @param smsApplicationSid Unique string that identifies the application
     * @return this
     */
    public IncomingPhoneNumberUpdater setSmsApplicationSid(final String smsApplicationSid) {
        this.smsApplicationSid = smsApplicationSid;
        return this;
    }

    /**
     * The HTTP method Twilio will use when requesting the above URL. Either `GET`
     * or `POST`..
     * 
     * @param smsFallbackMethod HTTP method used with sms fallback url
     * @return this
     */
    public IncomingPhoneNumberUpdater setSmsFallbackMethod(final HttpMethod smsFallbackMethod) {
        this.smsFallbackMethod = smsFallbackMethod;
        return this;
    }

    /**
     * The URL that Twilio will request if an error occurs retrieving or executing
     * the TwiML from `SmsUrl`..
     * 
     * @param smsFallbackUrl URL Twilio will request if an error occurs in
     *                       executing TwiML
     * @return this
     */
    public IncomingPhoneNumberUpdater setSmsFallbackUrl(final URI smsFallbackUrl) {
        this.smsFallbackUrl = smsFallbackUrl;
        return this;
    }

    /**
     * The URL that Twilio will request if an error occurs retrieving or executing
     * the TwiML from `SmsUrl`..
     * 
     * @param smsFallbackUrl URL Twilio will request if an error occurs in
     *                       executing TwiML
     * @return this
     */
    public IncomingPhoneNumberUpdater setSmsFallbackUrl(final String smsFallbackUrl) {
        return setSmsFallbackUrl(Promoter.uriFromString(smsFallbackUrl));
    }

    /**
     * The HTTP method Twilio will use when making requests to the `SmsUrl`. Either
     * `GET` or `POST`..
     * 
     * @param smsMethod HTTP method to use with sms url
     * @return this
     */
    public IncomingPhoneNumberUpdater setSmsMethod(final HttpMethod smsMethod) {
        this.smsMethod = smsMethod;
        return this;
    }

    /**
     * The URL Twilio will request when receiving an incoming SMS message to this
     * number..
     * 
     * @param smsUrl URL Twilio will request when receiving an SMS
     * @return this
     */
    public IncomingPhoneNumberUpdater setSmsUrl(final URI smsUrl) {
        this.smsUrl = smsUrl;
        return this;
    }

    /**
     * The URL Twilio will request when receiving an incoming SMS message to this
     * number..
     * 
     * @param smsUrl URL Twilio will request when receiving an SMS
     * @return this
     */
    public IncomingPhoneNumberUpdater setSmsUrl(final String smsUrl) {
        return setSmsUrl(Promoter.uriFromString(smsUrl));
    }

    /**
     * The URL that Twilio will request to pass status parameters (such as call
     * ended) to your application..
     * 
     * @param statusCallback URL Twilio will use to pass status parameters
     * @return this
     */
    public IncomingPhoneNumberUpdater setStatusCallback(final URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    /**
     * The URL that Twilio will request to pass status parameters (such as call
     * ended) to your application..
     * 
     * @param statusCallback URL Twilio will use to pass status parameters
     * @return this
     */
    public IncomingPhoneNumberUpdater setStatusCallback(final String statusCallback) {
        return setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    /**
     * The HTTP method Twilio will use to make requests to the `StatusCallback` URL.
     * Either `GET` or `POST`..
     * 
     * @param statusCallbackMethod HTTP method twilio will use with status callback
     * @return this
     */
    public IncomingPhoneNumberUpdater setStatusCallbackMethod(final HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    /**
     * The 34 character sid of the application Twilio should use to handle phone
     * calls to this number. If a `VoiceApplicationSid` is present, Twilio will
     * ignore all of the voice urls above and use those set on the application.
     * Setting a `VoiceApplicationSid` will automatically delete your `TrunkSid` and
     * vice versa..
     * 
     * @param voiceApplicationSid The unique sid of the application to handle this
     *                            number
     * @return this
     */
    public IncomingPhoneNumberUpdater setVoiceApplicationSid(final String voiceApplicationSid) {
        this.voiceApplicationSid = voiceApplicationSid;
        return this;
    }

    /**
     * Look up the caller's caller-ID name from the CNAM database ($0.01 per look
     * up). Either `true` or `false`..
     * 
     * @param voiceCallerIdLookup Look up the caller's caller-ID
     * @return this
     */
    public IncomingPhoneNumberUpdater setVoiceCallerIdLookup(final Boolean voiceCallerIdLookup) {
        this.voiceCallerIdLookup = voiceCallerIdLookup;
        return this;
    }

    /**
     * The HTTP method Twilio will use when requesting the `VoiceFallbackUrl`.
     * Either `GET` or `POST`..
     * 
     * @param voiceFallbackMethod HTTP method used with fallback_url
     * @return this
     */
    public IncomingPhoneNumberUpdater setVoiceFallbackMethod(final HttpMethod voiceFallbackMethod) {
        this.voiceFallbackMethod = voiceFallbackMethod;
        return this;
    }

    /**
     * The URL that Twilio will request if an error occurs retrieving or executing
     * the TwiML requested by `Url`..
     * 
     * @param voiceFallbackUrl URL Twilio will request when an error occurs in TwiML
     * @return this
     */
    public IncomingPhoneNumberUpdater setVoiceFallbackUrl(final URI voiceFallbackUrl) {
        this.voiceFallbackUrl = voiceFallbackUrl;
        return this;
    }

    /**
     * The URL that Twilio will request if an error occurs retrieving or executing
     * the TwiML requested by `Url`..
     * 
     * @param voiceFallbackUrl URL Twilio will request when an error occurs in TwiML
     * @return this
     */
    public IncomingPhoneNumberUpdater setVoiceFallbackUrl(final String voiceFallbackUrl) {
        return setVoiceFallbackUrl(Promoter.uriFromString(voiceFallbackUrl));
    }

    /**
     * The HTTP method Twilio will use when requesting the above `Url`. Either `GET`
     * or `POST`..
     * 
     * @param voiceMethod HTTP method used with the voice url
     * @return this
     */
    public IncomingPhoneNumberUpdater setVoiceMethod(final HttpMethod voiceMethod) {
        this.voiceMethod = voiceMethod;
        return this;
    }

    /**
     * The URL Twilio will request when this phone number receives a call. The
     * VoiceURL will  no longer be used if a `VoiceApplicationSid` or a `TrunkSid`
     * is set..
     * 
     * @param voiceUrl URL Twilio will request when receiving a call
     * @return this
     */
    public IncomingPhoneNumberUpdater setVoiceUrl(final URI voiceUrl) {
        this.voiceUrl = voiceUrl;
        return this;
    }

    /**
     * The URL Twilio will request when this phone number receives a call. The
     * VoiceURL will  no longer be used if a `VoiceApplicationSid` or a `TrunkSid`
     * is set..
     * 
     * @param voiceUrl URL Twilio will request when receiving a call
     * @return this
     */
    public IncomingPhoneNumberUpdater setVoiceUrl(final String voiceUrl) {
        return setVoiceUrl(Promoter.uriFromString(voiceUrl));
    }

    /**
     * The emergency_status.
     * 
     * @param emergencyStatus The emergency_status
     * @return this
     */
    public IncomingPhoneNumberUpdater setEmergencyStatus(final IncomingPhoneNumber.EmergencyStatus emergencyStatus) {
        this.emergencyStatus = emergencyStatus;
        return this;
    }

    /**
     * The emergency_address_sid.
     * 
     * @param emergencyAddressSid The emergency_address_sid
     * @return this
     */
    public IncomingPhoneNumberUpdater setEmergencyAddressSid(final String emergencyAddressSid) {
        this.emergencyAddressSid = emergencyAddressSid;
        return this;
    }

    /**
     * The 34 character sid of the Trunk Twilio should use to handle phone calls to
     * this number. If a `TrunkSid` is present, Twilio will ignore all of the voice
     * urls  and voice applications above and use those set on the Trunk. Setting a
     * `TrunkSid` will automatically delete your `VoiceApplicationSid` and vice
     * versa..
     * 
     * @param trunkSid Unique string to identify the trunk
     * @return this
     */
    public IncomingPhoneNumberUpdater setTrunkSid(final String trunkSid) {
        this.trunkSid = trunkSid;
        return this;
    }

    /**
     * The voice_receive_mode.
     * 
     * @param voiceReceiveMode The voice_receive_mode
     * @return this
     */
    public IncomingPhoneNumberUpdater setVoiceReceiveMode(final IncomingPhoneNumber.VoiceReceiveMode voiceReceiveMode) {
        this.voiceReceiveMode = voiceReceiveMode;
        return this;
    }

    /**
     * The 34 character sid of the identity Twilio should use to associate with the
     * number. Identities are required in some regions to meet local regulations.
     * 
     * @param identitySid Unique string that identifies the identity associated
     *                    with number
     * @return this
     */
    public IncomingPhoneNumberUpdater setIdentitySid(final String identitySid) {
        this.identitySid = identitySid;
        return this;
    }

    /**
     * The 34 character sid of the address Twilio should use to associate with the
     * number. Addresses are required in some regions to meet local regulations.
     * 
     * @param addressSid Unique string that identifies the address associated with
     *                   number
     * @return this
     */
    public IncomingPhoneNumberUpdater setAddressSid(final String addressSid) {
        this.addressSid = addressSid;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return Updated IncomingPhoneNumber
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public IncomingPhoneNumber update(final TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(
            HttpMethod.POST,
            Domains.API.toString(),
            "/2010-04-01/Accounts/" + this.pathAccountSid + "/IncomingPhoneNumbers/" + this.pathSid + ".json",
            client.getRegion()
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("IncomingPhoneNumber update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }

            throw new ApiException(
                restException.getMessage(),
                restException.getCode(),
                restException.getMoreInfo(),
                restException.getStatus(),
                null
            );
        }

        return IncomingPhoneNumber.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     * 
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (accountSid != null) {
            request.addPostParam("AccountSid", accountSid);
        }

        if (apiVersion != null) {
            request.addPostParam("ApiVersion", apiVersion);
        }

        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (smsApplicationSid != null) {
            request.addPostParam("SmsApplicationSid", smsApplicationSid);
        }

        if (smsFallbackMethod != null) {
            request.addPostParam("SmsFallbackMethod", smsFallbackMethod.toString());
        }

        if (smsFallbackUrl != null) {
            request.addPostParam("SmsFallbackUrl", smsFallbackUrl.toString());
        }

        if (smsMethod != null) {
            request.addPostParam("SmsMethod", smsMethod.toString());
        }

        if (smsUrl != null) {
            request.addPostParam("SmsUrl", smsUrl.toString());
        }

        if (statusCallback != null) {
            request.addPostParam("StatusCallback", statusCallback.toString());
        }

        if (statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", statusCallbackMethod.toString());
        }

        if (voiceApplicationSid != null) {
            request.addPostParam("VoiceApplicationSid", voiceApplicationSid);
        }

        if (voiceCallerIdLookup != null) {
            request.addPostParam("VoiceCallerIdLookup", voiceCallerIdLookup.toString());
        }

        if (voiceFallbackMethod != null) {
            request.addPostParam("VoiceFallbackMethod", voiceFallbackMethod.toString());
        }

        if (voiceFallbackUrl != null) {
            request.addPostParam("VoiceFallbackUrl", voiceFallbackUrl.toString());
        }

        if (voiceMethod != null) {
            request.addPostParam("VoiceMethod", voiceMethod.toString());
        }

        if (voiceUrl != null) {
            request.addPostParam("VoiceUrl", voiceUrl.toString());
        }

        if (emergencyStatus != null) {
            request.addPostParam("EmergencyStatus", emergencyStatus.toString());
        }

        if (emergencyAddressSid != null) {
            request.addPostParam("EmergencyAddressSid", emergencyAddressSid);
        }

        if (trunkSid != null) {
            request.addPostParam("TrunkSid", trunkSid);
        }

        if (voiceReceiveMode != null) {
            request.addPostParam("VoiceReceiveMode", voiceReceiveMode.toString());
        }

        if (identitySid != null) {
            request.addPostParam("IdentitySid", identitySid);
        }

        if (addressSid != null) {
            request.addPostParam("AddressSid", addressSid);
        }
    }
}