/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.math.BigDecimal;
import java.net.URI;
import java.util.List;

public class MessageCreator extends Creator<Message> {
    private String pathAccountSid;
    private final com.twilio.type.PhoneNumber to;
    private com.twilio.type.PhoneNumber from;
    private String messagingServiceSid;
    private String body;
    private List<URI> mediaUrl;
    private URI statusCallback;
    private String applicationSid;
    private BigDecimal maxPrice;
    private Boolean provideFeedback;
    private Integer validityPeriod;
    private String maxRate;
    private Boolean forceDelivery;
    private String providerSid;
    private Message.ContentRetention contentRetention;
    private Message.AddressRetention addressRetention;
    private Boolean smartEncoded;

    /**
     * Construct a new MessageCreator.
     * 
     * @param to The phone number to receive the message
     * @param from The phone number that initiated the message
     * @param body The body
     */
    public MessageCreator(final com.twilio.type.PhoneNumber to, 
                          final com.twilio.type.PhoneNumber from, 
                          final String body) {
        this.to = to;
        this.from = from;
        this.body = body;
    }

    /**
     * Construct a new MessageCreator.
     * 
     * @param pathAccountSid The account_sid
     * @param to The phone number to receive the message
     * @param from The phone number that initiated the message
     * @param body The body
     */
    public MessageCreator(final String pathAccountSid, 
                          final com.twilio.type.PhoneNumber to, 
                          final com.twilio.type.PhoneNumber from, 
                          final String body) {
        this.pathAccountSid = pathAccountSid;
        this.to = to;
        this.from = from;
        this.body = body;
    }

    /**
     * Construct a new MessageCreator.
     * 
     * @param to The phone number to receive the message
     * @param from The phone number that initiated the message
     * @param mediaUrl The media_url
     */
    public MessageCreator(final com.twilio.type.PhoneNumber to, 
                          final com.twilio.type.PhoneNumber from, 
                          final List<URI> mediaUrl) {
        this.to = to;
        this.from = from;
        this.mediaUrl = mediaUrl;
    }

    /**
     * Construct a new MessageCreator.
     * 
     * @param pathAccountSid The account_sid
     * @param to The phone number to receive the message
     * @param from The phone number that initiated the message
     * @param mediaUrl The media_url
     */
    public MessageCreator(final String pathAccountSid, 
                          final com.twilio.type.PhoneNumber to, 
                          final com.twilio.type.PhoneNumber from, 
                          final List<URI> mediaUrl) {
        this.pathAccountSid = pathAccountSid;
        this.to = to;
        this.from = from;
        this.mediaUrl = mediaUrl;
    }

    /**
     * Construct a new MessageCreator.
     * 
     * @param to The phone number to receive the message
     * @param messagingServiceSid The messaging_service_sid
     * @param body The body
     */
    public MessageCreator(final com.twilio.type.PhoneNumber to, 
                          final String messagingServiceSid, 
                          final String body) {
        this.to = to;
        this.messagingServiceSid = messagingServiceSid;
        this.body = body;
    }

    /**
     * Construct a new MessageCreator.
     * 
     * @param pathAccountSid The account_sid
     * @param to The phone number to receive the message
     * @param messagingServiceSid The messaging_service_sid
     * @param body The body
     */
    public MessageCreator(final String pathAccountSid, 
                          final com.twilio.type.PhoneNumber to, 
                          final String messagingServiceSid, 
                          final String body) {
        this.pathAccountSid = pathAccountSid;
        this.to = to;
        this.messagingServiceSid = messagingServiceSid;
        this.body = body;
    }

    /**
     * Construct a new MessageCreator.
     * 
     * @param to The phone number to receive the message
     * @param messagingServiceSid The messaging_service_sid
     * @param mediaUrl The media_url
     */
    public MessageCreator(final com.twilio.type.PhoneNumber to, 
                          final String messagingServiceSid, 
                          final List<URI> mediaUrl) {
        this.to = to;
        this.messagingServiceSid = messagingServiceSid;
        this.mediaUrl = mediaUrl;
    }

    /**
     * Construct a new MessageCreator.
     * 
     * @param pathAccountSid The account_sid
     * @param to The phone number to receive the message
     * @param messagingServiceSid The messaging_service_sid
     * @param mediaUrl The media_url
     */
    public MessageCreator(final String pathAccountSid, 
                          final com.twilio.type.PhoneNumber to, 
                          final String messagingServiceSid, 
                          final List<URI> mediaUrl) {
        this.pathAccountSid = pathAccountSid;
        this.to = to;
        this.messagingServiceSid = messagingServiceSid;
        this.mediaUrl = mediaUrl;
    }

    /**
     * The URL that Twilio will POST to each time your message status changes.
     * 
     * @param statusCallback URL Twilio will request when the status changes
     * @return this
     */
    public MessageCreator setStatusCallback(final URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    /**
     * The URL that Twilio will POST to each time your message status changes.
     * 
     * @param statusCallback URL Twilio will request when the status changes
     * @return this
     */
    public MessageCreator setStatusCallback(final String statusCallback) {
        return setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    /**
     * Twilio the POST MessageSid as well as MessageStatus to the URL in the
     * MessageStatusCallback property of this Application.
     * 
     * @param applicationSid The application to use for callbacks
     * @return this
     */
    public MessageCreator setApplicationSid(final String applicationSid) {
        this.applicationSid = applicationSid;
        return this;
    }

    /**
     * The max_price.
     * 
     * @param maxPrice The max_price
     * @return this
     */
    public MessageCreator setMaxPrice(final BigDecimal maxPrice) {
        this.maxPrice = maxPrice;
        return this;
    }

    /**
     * The provide_feedback.
     * 
     * @param provideFeedback The provide_feedback
     * @return this
     */
    public MessageCreator setProvideFeedback(final Boolean provideFeedback) {
        this.provideFeedback = provideFeedback;
        return this;
    }

    /**
     * The validity_period.
     * 
     * @param validityPeriod The validity_period
     * @return this
     */
    public MessageCreator setValidityPeriod(final Integer validityPeriod) {
        this.validityPeriod = validityPeriod;
        return this;
    }

    /**
     * The max_rate.
     * 
     * @param maxRate The max_rate
     * @return this
     */
    public MessageCreator setMaxRate(final String maxRate) {
        this.maxRate = maxRate;
        return this;
    }

    /**
     * The force_delivery.
     * 
     * @param forceDelivery The force_delivery
     * @return this
     */
    public MessageCreator setForceDelivery(final Boolean forceDelivery) {
        this.forceDelivery = forceDelivery;
        return this;
    }

    /**
     * The provider_sid.
     * 
     * @param providerSid The provider_sid
     * @return this
     */
    public MessageCreator setProviderSid(final String providerSid) {
        this.providerSid = providerSid;
        return this;
    }

    /**
     * The content_retention.
     * 
     * @param contentRetention The content_retention
     * @return this
     */
    public MessageCreator setContentRetention(final Message.ContentRetention contentRetention) {
        this.contentRetention = contentRetention;
        return this;
    }

    /**
     * The address_retention.
     * 
     * @param addressRetention The address_retention
     * @return this
     */
    public MessageCreator setAddressRetention(final Message.AddressRetention addressRetention) {
        this.addressRetention = addressRetention;
        return this;
    }

    /**
     * The smart_encoded.
     * 
     * @param smartEncoded The smart_encoded
     * @return this
     */
    public MessageCreator setSmartEncoded(final Boolean smartEncoded) {
        this.smartEncoded = smartEncoded;
        return this;
    }

    /**
     * A Twilio phone number or alphanumeric sender ID enabled for the type of
     * message you wish to send..
     * 
     * @param from The phone number that initiated the message
     * @return this
     */
    public MessageCreator setFrom(final com.twilio.type.PhoneNumber from) {
        this.from = from;
        return this;
    }

    /**
     * A Twilio phone number or alphanumeric sender ID enabled for the type of
     * message you wish to send..
     * 
     * @param from The phone number that initiated the message
     * @return this
     */
    public MessageCreator setFrom(final String from) {
        return setFrom(Promoter.phoneNumberFromString(from));
    }

    /**
     * The messaging_service_sid.
     * 
     * @param messagingServiceSid The messaging_service_sid
     * @return this
     */
    public MessageCreator setMessagingServiceSid(final String messagingServiceSid) {
        this.messagingServiceSid = messagingServiceSid;
        return this;
    }

    /**
     * The body.
     * 
     * @param body The body
     * @return this
     */
    public MessageCreator setBody(final String body) {
        this.body = body;
        return this;
    }

    /**
     * The media_url.
     * 
     * @param mediaUrl The media_url
     * @return this
     */
    public MessageCreator setMediaUrl(final List<URI> mediaUrl) {
        this.mediaUrl = mediaUrl;
        return this;
    }

    /**
     * The media_url.
     * 
     * @param mediaUrl The media_url
     * @return this
     */
    public MessageCreator setMediaUrl(final URI mediaUrl) {
        return setMediaUrl(Promoter.listOfOne(mediaUrl));
    }

    /**
     * The media_url.
     * 
     * @param mediaUrl The media_url
     * @return this
     */
    public MessageCreator setMediaUrl(final String mediaUrl) {
        return setMediaUrl(Promoter.uriFromString(mediaUrl));
    }

    /**
     * Make the request to the Twilio API to perform the create.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return Created Message
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Message create(final TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(
            HttpMethod.POST,
            Domains.API.toString(),
            "/2010-04-01/Accounts/" + this.pathAccountSid + "/Messages.json",
            client.getRegion()
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Message creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }

            throw new ApiException(
                restException.getMessage(),
                restException.getCode(),
                restException.getMoreInfo(),
                restException.getStatus(),
                null
            );
        }

        return Message.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     * 
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (to != null) {
            request.addPostParam("To", to.toString());
        }

        if (from != null) {
            request.addPostParam("From", from.toString());
        }

        if (messagingServiceSid != null) {
            request.addPostParam("MessagingServiceSid", messagingServiceSid);
        }

        if (body != null) {
            request.addPostParam("Body", body);
        }

        if (mediaUrl != null) {
            for (URI prop : mediaUrl) {
                request.addPostParam("MediaUrl", prop.toString());
            }
        }

        if (statusCallback != null) {
            request.addPostParam("StatusCallback", statusCallback.toString());
        }

        if (applicationSid != null) {
            request.addPostParam("ApplicationSid", applicationSid);
        }

        if (maxPrice != null) {
            request.addPostParam("MaxPrice", maxPrice.toString());
        }

        if (provideFeedback != null) {
            request.addPostParam("ProvideFeedback", provideFeedback.toString());
        }

        if (validityPeriod != null) {
            request.addPostParam("ValidityPeriod", validityPeriod.toString());
        }

        if (maxRate != null) {
            request.addPostParam("MaxRate", maxRate);
        }

        if (forceDelivery != null) {
            request.addPostParam("ForceDelivery", forceDelivery.toString());
        }

        if (providerSid != null) {
            request.addPostParam("ProviderSid", providerSid);
        }

        if (contentRetention != null) {
            request.addPostParam("ContentRetention", contentRetention.toString());
        }

        if (addressRetention != null) {
            request.addPostParam("AddressRetention", addressRetention.toString());
        }

        if (smartEncoded != null) {
            request.addPostParam("SmartEncoded", smartEncoded.toString());
        }
    }
}