/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import org.joda.time.DateTime;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Queue extends Resource {
    private static final long serialVersionUID = 51300543687284L;

    /**
     * Create a QueueFetcher to execute fetch.
     * 
     * @param pathAccountSid The account_sid
     * @param pathSid Fetch by unique queue Sid
     * @return QueueFetcher capable of executing the fetch
     */
    public static QueueFetcher fetcher(final String pathAccountSid, 
                                       final String pathSid) {
        return new QueueFetcher(pathAccountSid, pathSid);
    }

    /**
     * Create a QueueFetcher to execute fetch.
     * 
     * @param pathSid Fetch by unique queue Sid
     * @return QueueFetcher capable of executing the fetch
     */
    public static QueueFetcher fetcher(final String pathSid) {
        return new QueueFetcher(pathSid);
    }

    /**
     * Create a QueueUpdater to execute update.
     * 
     * @param pathAccountSid The account_sid
     * @param pathSid The sid
     * @return QueueUpdater capable of executing the update
     */
    public static QueueUpdater updater(final String pathAccountSid, 
                                       final String pathSid) {
        return new QueueUpdater(pathAccountSid, pathSid);
    }

    /**
     * Create a QueueUpdater to execute update.
     * 
     * @param pathSid The sid
     * @return QueueUpdater capable of executing the update
     */
    public static QueueUpdater updater(final String pathSid) {
        return new QueueUpdater(pathSid);
    }

    /**
     * Create a QueueDeleter to execute delete.
     * 
     * @param pathAccountSid The account_sid
     * @param pathSid Delete by unique queue Sid
     * @return QueueDeleter capable of executing the delete
     */
    public static QueueDeleter deleter(final String pathAccountSid, 
                                       final String pathSid) {
        return new QueueDeleter(pathAccountSid, pathSid);
    }

    /**
     * Create a QueueDeleter to execute delete.
     * 
     * @param pathSid Delete by unique queue Sid
     * @return QueueDeleter capable of executing the delete
     */
    public static QueueDeleter deleter(final String pathSid) {
        return new QueueDeleter(pathSid);
    }

    /**
     * Create a QueueReader to execute read.
     * 
     * @param pathAccountSid The account_sid
     * @return QueueReader capable of executing the read
     */
    public static QueueReader reader(final String pathAccountSid) {
        return new QueueReader(pathAccountSid);
    }

    /**
     * Create a QueueReader to execute read.
     * 
     * @return QueueReader capable of executing the read
     */
    public static QueueReader reader() {
        return new QueueReader();
    }

    /**
     * Create a QueueCreator to execute create.
     * 
     * @param pathAccountSid The account_sid
     * @param friendlyName A user-provided string that identifies this queue.
     * @return QueueCreator capable of executing the create
     */
    public static QueueCreator creator(final String pathAccountSid, 
                                       final String friendlyName) {
        return new QueueCreator(pathAccountSid, friendlyName);
    }

    /**
     * Create a QueueCreator to execute create.
     * 
     * @param friendlyName A user-provided string that identifies this queue.
     * @return QueueCreator capable of executing the create
     */
    public static QueueCreator creator(final String friendlyName) {
        return new QueueCreator(friendlyName);
    }

    /**
     * Converts a JSON String into a Queue object using the provided ObjectMapper.
     * 
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Queue object represented by the provided JSON
     */
    public static Queue fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Queue.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Queue object using the provided
     * ObjectMapper.
     * 
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Queue object represented by the provided JSON
     */
    public static Queue fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Queue.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final Integer averageWaitTime;
    private final Integer currentSize;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final Integer maxSize;
    private final String sid;
    private final String uri;

    @JsonCreator
    private Queue(@JsonProperty("account_sid")
                  final String accountSid, 
                  @JsonProperty("average_wait_time")
                  final Integer averageWaitTime, 
                  @JsonProperty("current_size")
                  final Integer currentSize, 
                  @JsonProperty("date_created")
                  final String dateCreated, 
                  @JsonProperty("date_updated")
                  final String dateUpdated, 
                  @JsonProperty("friendly_name")
                  final String friendlyName, 
                  @JsonProperty("max_size")
                  final Integer maxSize, 
                  @JsonProperty("sid")
                  final String sid, 
                  @JsonProperty("uri")
                  final String uri) {
        this.accountSid = accountSid;
        this.averageWaitTime = averageWaitTime;
        this.currentSize = currentSize;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.maxSize = maxSize;
        this.sid = sid;
        this.uri = uri;
    }

    /**
     * Returns The The account_sid.
     * 
     * @return The account_sid
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The Average wait time of members in the queue.
     * 
     * @return Average wait time of members in the queue
     */
    public final Integer getAverageWaitTime() {
        return this.averageWaitTime;
    }

    /**
     * Returns The The count of calls currently in the queue..
     * 
     * @return The count of calls currently in the queue.
     */
    public final Integer getCurrentSize() {
        return this.currentSize;
    }

    /**
     * Returns The The date_created.
     * 
     * @return The date_created
     */
    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The The date_updated.
     * 
     * @return The date_updated
     */
    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The A user-provided string that identifies this queue..
     * 
     * @return A user-provided string that identifies this queue.
     */
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    /**
     * Returns The The max number of calls allowed in the queue.
     * 
     * @return The max number of calls allowed in the queue
     */
    public final Integer getMaxSize() {
        return this.maxSize;
    }

    /**
     * Returns The A string that uniquely identifies this queue.
     * 
     * @return A string that uniquely identifies this queue
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The The uri.
     * 
     * @return The uri
     */
    public final String getUri() {
        return this.uri;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Queue other = (Queue) o;

        return Objects.equals(accountSid, other.accountSid) && 
               Objects.equals(averageWaitTime, other.averageWaitTime) && 
               Objects.equals(currentSize, other.currentSize) && 
               Objects.equals(dateCreated, other.dateCreated) && 
               Objects.equals(dateUpdated, other.dateUpdated) && 
               Objects.equals(friendlyName, other.friendlyName) && 
               Objects.equals(maxSize, other.maxSize) && 
               Objects.equals(sid, other.sid) && 
               Objects.equals(uri, other.uri);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            averageWaitTime,
                            currentSize,
                            dateCreated,
                            dateUpdated,
                            friendlyName,
                            maxSize,
                            sid,
                            uri);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                          .add("accountSid", accountSid)
                          .add("averageWaitTime", averageWaitTime)
                          .add("currentSize", currentSize)
                          .add("dateCreated", dateCreated)
                          .add("dateUpdated", dateUpdated)
                          .add("friendlyName", friendlyName)
                          .add("maxSize", maxSize)
                          .add("sid", sid)
                          .add("uri", uri)
                          .toString();
    }
}