/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class QueueUpdater extends Updater<Queue> {
    private String pathAccountSid;
    private final String pathSid;
    private String friendlyName;
    private Integer maxSize;

    /**
     * Construct a new QueueUpdater.
     * 
     * @param pathSid The sid
     */
    public QueueUpdater(final String pathSid) {
        this.pathSid = pathSid;
    }

    /**
     * Construct a new QueueUpdater.
     * 
     * @param pathAccountSid The account_sid
     * @param pathSid The sid
     */
    public QueueUpdater(final String pathAccountSid, 
                        final String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathSid = pathSid;
    }

    /**
     * A human readable description of the queue.
     * 
     * @param friendlyName A human readable description of the queue
     * @return this
     */
    public QueueUpdater setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    /**
     * The maximum number of members that can be in the queue at a time.
     * 
     * @param maxSize The max number of members allowed in the queue
     * @return this
     */
    public QueueUpdater setMaxSize(final Integer maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return Updated Queue
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Queue update(final TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(
            HttpMethod.POST,
            Domains.API.toString(),
            "/2010-04-01/Accounts/" + this.pathAccountSid + "/Queues/" + this.pathSid + ".json",
            client.getRegion()
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Queue update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }

            throw new ApiException(
                restException.getMessage(),
                restException.getCode(),
                restException.getMoreInfo(),
                restException.getStatus(),
                null
            );
        }

        return Queue.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     * 
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (maxSize != null) {
            request.addPostParam("MaxSize", maxSize.toString());
        }
    }
}