/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account.queue;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import org.joda.time.DateTime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Member extends Resource {
    private static final long serialVersionUID = 27782479642114L;

    /**
     * Create a MemberFetcher to execute fetch.
     * 
     * @param pathAccountSid The account_sid
     * @param pathQueueSid The Queue in which to find the members
     * @param pathCallSid The call_sid
     * @return MemberFetcher capable of executing the fetch
     */
    public static MemberFetcher fetcher(final String pathAccountSid, 
                                        final String pathQueueSid, 
                                        final String pathCallSid) {
        return new MemberFetcher(pathAccountSid, pathQueueSid, pathCallSid);
    }

    /**
     * Create a MemberFetcher to execute fetch.
     * 
     * @param pathQueueSid The Queue in which to find the members
     * @param pathCallSid The call_sid
     * @return MemberFetcher capable of executing the fetch
     */
    public static MemberFetcher fetcher(final String pathQueueSid, 
                                        final String pathCallSid) {
        return new MemberFetcher(pathQueueSid, pathCallSid);
    }

    /**
     * Create a MemberUpdater to execute update.
     * 
     * @param pathAccountSid The account_sid
     * @param pathQueueSid The Queue in which to find the members
     * @param pathCallSid The call_sid
     * @param url The url
     * @param method The method
     * @return MemberUpdater capable of executing the update
     */
    public static MemberUpdater updater(final String pathAccountSid, 
                                        final String pathQueueSid, 
                                        final String pathCallSid, 
                                        final URI url, 
                                        final HttpMethod method) {
        return new MemberUpdater(pathAccountSid, pathQueueSid, pathCallSid, url, method);
    }

    /**
     * Create a MemberUpdater to execute update.
     * 
     * @param pathQueueSid The Queue in which to find the members
     * @param pathCallSid The call_sid
     * @param url The url
     * @param method The method
     * @return MemberUpdater capable of executing the update
     */
    public static MemberUpdater updater(final String pathQueueSid, 
                                        final String pathCallSid, 
                                        final URI url, 
                                        final HttpMethod method) {
        return new MemberUpdater(pathQueueSid, pathCallSid, url, method);
    }

    /**
     * Create a MemberReader to execute read.
     * 
     * @param pathAccountSid The account_sid
     * @param pathQueueSid The Queue in which to find members
     * @return MemberReader capable of executing the read
     */
    public static MemberReader reader(final String pathAccountSid, 
                                      final String pathQueueSid) {
        return new MemberReader(pathAccountSid, pathQueueSid);
    }

    /**
     * Create a MemberReader to execute read.
     * 
     * @param pathQueueSid The Queue in which to find members
     * @return MemberReader capable of executing the read
     */
    public static MemberReader reader(final String pathQueueSid) {
        return new MemberReader(pathQueueSid);
    }

    /**
     * Converts a JSON String into a Member object using the provided ObjectMapper.
     * 
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Member object represented by the provided JSON
     */
    public static Member fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Member.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Member object using the provided
     * ObjectMapper.
     * 
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Member object represented by the provided JSON
     */
    public static Member fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Member.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String callSid;
    private final DateTime dateEnqueued;
    private final Integer position;
    private final String uri;
    private final Integer waitTime;

    @JsonCreator
    private Member(@JsonProperty("call_sid")
                   final String callSid, 
                   @JsonProperty("date_enqueued")
                   final String dateEnqueued, 
                   @JsonProperty("position")
                   final Integer position, 
                   @JsonProperty("uri")
                   final String uri, 
                   @JsonProperty("wait_time")
                   final Integer waitTime) {
        this.callSid = callSid;
        this.dateEnqueued = DateConverter.rfc2822DateTimeFromString(dateEnqueued);
        this.position = position;
        this.uri = uri;
        this.waitTime = waitTime;
    }

    /**
     * Returns The Unique string that identifies this resource.
     * 
     * @return Unique string that identifies this resource
     */
    public final String getCallSid() {
        return this.callSid;
    }

    /**
     * Returns The The date the member was enqueued.
     * 
     * @return The date the member was enqueued
     */
    public final DateTime getDateEnqueued() {
        return this.dateEnqueued;
    }

    /**
     * Returns The This member's current position in the queue..
     * 
     * @return This member's current position in the queue.
     */
    public final Integer getPosition() {
        return this.position;
    }

    /**
     * Returns The The uri.
     * 
     * @return The uri
     */
    public final String getUri() {
        return this.uri;
    }

    /**
     * Returns The The number of seconds the member has been in the queue..
     * 
     * @return The number of seconds the member has been in the queue.
     */
    public final Integer getWaitTime() {
        return this.waitTime;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Member other = (Member) o;

        return Objects.equals(callSid, other.callSid) && 
               Objects.equals(dateEnqueued, other.dateEnqueued) && 
               Objects.equals(position, other.position) && 
               Objects.equals(uri, other.uri) && 
               Objects.equals(waitTime, other.waitTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(callSid,
                            dateEnqueued,
                            position,
                            uri,
                            waitTime);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                          .add("callSid", callSid)
                          .add("dateEnqueued", dateEnqueued)
                          .add("position", position)
                          .add("uri", uri)
                          .add("waitTime", waitTime)
                          .toString();
    }
}