/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.fax.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import org.joda.time.DateTime;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class FaxReader extends Reader<Fax> {
    private String from;
    private String to;
    private DateTime dateCreatedOnOrBefore;
    private DateTime dateCreatedAfter;

    /**
     * Filters the returned list to only include faxes sent from the supplied
     * number, given in E.164 format..
     * 
     * @param from Include only faxes sent from
     * @return this
     */
    public FaxReader setFrom(final String from) {
        this.from = from;
        return this;
    }

    /**
     * Filters the returned list to only include faxes sent to the supplied number,
     * given in E.164 format..
     * 
     * @param to Include only faxes sent to
     * @return this
     */
    public FaxReader setTo(final String to) {
        this.to = to;
        return this;
    }

    /**
     * Filters the returned list to only include faxes created on or before the
     * supplied date, given in ISO 8601 format..
     * 
     * @param dateCreatedOnOrBefore Include only faxes created on or before
     * @return this
     */
    public FaxReader setDateCreatedOnOrBefore(final DateTime dateCreatedOnOrBefore) {
        this.dateCreatedOnOrBefore = dateCreatedOnOrBefore;
        return this;
    }

    /**
     * Filters the returned list to only include faxes created after the supplied
     * date, given in ISO 8601 format..
     * 
     * @param dateCreatedAfter Include only faxes created after
     * @return this
     */
    public FaxReader setDateCreatedAfter(final DateTime dateCreatedAfter) {
        this.dateCreatedAfter = dateCreatedAfter;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the read.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return Fax ResourceSet
     */
    @Override
    public ResourceSet<Fax> read(final TwilioRestClient client) {
        return new ResourceSet<>(this, client, firstPage(client));
    }

    /**
     * Make the request to the Twilio API to perform the read.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return Fax ResourceSet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Page<Fax> firstPage(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.FAX.toString(),
            "/v1/Faxes",
            client.getRegion()
        );

        addQueryParams(request);
        return pageForRequest(client, request);
    }

    /**
     * Retrieve the target page from the Twilio API.
     * 
     * @param targetUrl API-generated URL for the requested results page
     * @param client TwilioRestClient with which to make the request
     * @return Fax ResourceSet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Page<Fax> getPage(final String targetUrl, final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            targetUrl
        );

        return pageForRequest(client, request);
    }

    /**
     * Retrieve the next page from the Twilio API.
     * 
     * @param page current page
     * @param client TwilioRestClient with which to make the request
     * @return Next Page
     */
    @Override
    public Page<Fax> nextPage(final Page<Fax> page, 
                              final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            page.getNextPageUrl(
                Domains.FAX.toString(),
                client.getRegion()
            )
        );
        return pageForRequest(client, request);
    }

    /**
     * Retrieve the previous page from the Twilio API.
     * 
     * @param page current page
     * @param client TwilioRestClient with which to make the request
     * @return Previous Page
     */
    @Override
    public Page<Fax> previousPage(final Page<Fax> page, 
                                  final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            page.getPreviousPageUrl(
                Domains.FAX.toString(),
                client.getRegion()
            )
        );
        return pageForRequest(client, request);
    }

    /**
     * Generate a Page of Fax Resources for a given request.
     * 
     * @param client TwilioRestClient with which to make the request
     * @param request Request to generate a page for
     * @return Page for the Request
     */
    private Page<Fax> pageForRequest(final TwilioRestClient client, final Request request) {
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Fax read failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }

            throw new ApiException(
                restException.getMessage(),
                restException.getCode(),
                restException.getMoreInfo(),
                restException.getStatus(),
                null
            );
        }

        return Page.fromJson(
            "faxes",
            response.getContent(),
            Fax.class,
            client.getObjectMapper()
        );
    }

    /**
     * Add the requested query string arguments to the Request.
     * 
     * @param request Request to add query string arguments to
     */
    private void addQueryParams(final Request request) {
        if (from != null) {
            request.addQueryParam("From", from);
        }

        if (to != null) {
            request.addQueryParam("To", to);
        }

        if (dateCreatedOnOrBefore != null) {
            request.addQueryParam("DateCreatedOnOrBefore", dateCreatedOnOrBefore.toString());
        }

        if (dateCreatedAfter != null) {
            request.addQueryParam("DateCreatedAfter", dateCreatedAfter.toString());
        }

        if (getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(getPageSize()));
        }
    }
}