/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.lookups.v1;

import com.twilio.base.Fetcher;
import com.twilio.converter.PrefixedCollapsibleMap;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.util.List;
import java.util.Map;

public class PhoneNumberFetcher extends Fetcher<PhoneNumber> {
    private final com.twilio.type.PhoneNumber pathPhoneNumber;
    private String countryCode;
    private List<String> type;
    private List<String> addOns;
    private Map<String, Object> addOnsData;

    /**
     * Construct a new PhoneNumberFetcher.
     * 
     * @param pathPhoneNumber The phone_number
     */
    public PhoneNumberFetcher(final com.twilio.type.PhoneNumber pathPhoneNumber) {
        this.pathPhoneNumber = pathPhoneNumber;
    }

    /**
     * The country_code.
     * 
     * @param countryCode The country_code
     * @return this
     */
    public PhoneNumberFetcher setCountryCode(final String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    /**
     * The type.
     * 
     * @param type The type
     * @return this
     */
    public PhoneNumberFetcher setType(final List<String> type) {
        this.type = type;
        return this;
    }

    /**
     * The type.
     * 
     * @param type The type
     * @return this
     */
    public PhoneNumberFetcher setType(final String type) {
        return setType(Promoter.listOfOne(type));
    }

    /**
     * The add_ons.
     * 
     * @param addOns The add_ons
     * @return this
     */
    public PhoneNumberFetcher setAddOns(final List<String> addOns) {
        this.addOns = addOns;
        return this;
    }

    /**
     * The add_ons.
     * 
     * @param addOns The add_ons
     * @return this
     */
    public PhoneNumberFetcher setAddOns(final String addOns) {
        return setAddOns(Promoter.listOfOne(addOns));
    }

    /**
     * The add_ons_data.
     * 
     * @param addOnsData The add_ons_data
     * @return this
     */
    public PhoneNumberFetcher setAddOnsData(final Map<String, Object> addOnsData) {
        this.addOnsData = addOnsData;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return Fetched PhoneNumber
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public PhoneNumber fetch(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.LOOKUPS.toString(),
            "/v1/PhoneNumbers/" + this.pathPhoneNumber + "",
            client.getRegion()
        );

        addQueryParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("PhoneNumber fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }

            throw new ApiException(
                restException.getMessage(),
                restException.getCode(),
                restException.getMoreInfo(),
                restException.getStatus(),
                null
            );
        }

        return PhoneNumber.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested query string arguments to the Request.
     * 
     * @param request Request to add query string arguments to
     */
    private void addQueryParams(final Request request) {
        if (countryCode != null) {
            request.addQueryParam("CountryCode", countryCode);
        }

        if (type != null) {
            for (String prop : type) {
                request.addQueryParam("Type", prop);
            }
        }

        if (addOns != null) {
            for (String prop : addOns) {
                request.addQueryParam("AddOns", prop);
            }
        }

        if (addOnsData != null) {
            Map<String, String> params = PrefixedCollapsibleMap.serialize(addOnsData, "AddOns");
            for (Map.Entry<String, String> entry : params.entrySet()) {
                request.addQueryParam(entry.getKey(), entry.getValue());
            }
        }
    }
}