/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.messaging.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import org.joda.time.DateTime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Service extends Resource {
    private static final long serialVersionUID = 155674022160031L;

    public enum ScanMessageContent {
        INHERIT("inherit"),
        ENABLE("enable"),
        DISABLE("disable");

        private final String value;

        private ScanMessageContent(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a ScanMessageContent from a string.
         * @param value string value
         * @return generated ScanMessageContent
         */
        @JsonCreator
        public static ScanMessageContent forValue(final String value) {
            return Promoter.enumFromString(value, ScanMessageContent.values());
        }
    }

    /**
     * Create a ServiceCreator to execute create.
     * 
     * @param friendlyName The friendly_name
     * @return ServiceCreator capable of executing the create
     */
    public static ServiceCreator creator(final String friendlyName) {
        return new ServiceCreator(friendlyName);
    }

    /**
     * Create a ServiceUpdater to execute update.
     * 
     * @param pathSid The sid
     * @return ServiceUpdater capable of executing the update
     */
    public static ServiceUpdater updater(final String pathSid) {
        return new ServiceUpdater(pathSid);
    }

    /**
     * Create a ServiceReader to execute read.
     * 
     * @return ServiceReader capable of executing the read
     */
    public static ServiceReader reader() {
        return new ServiceReader();
    }

    /**
     * Create a ServiceFetcher to execute fetch.
     * 
     * @param pathSid The sid
     * @return ServiceFetcher capable of executing the fetch
     */
    public static ServiceFetcher fetcher(final String pathSid) {
        return new ServiceFetcher(pathSid);
    }

    /**
     * Create a ServiceDeleter to execute delete.
     * 
     * @param pathSid The sid
     * @return ServiceDeleter capable of executing the delete
     */
    public static ServiceDeleter deleter(final String pathSid) {
        return new ServiceDeleter(pathSid);
    }

    /**
     * Converts a JSON String into a Service object using the provided ObjectMapper.
     * 
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Service object represented by the provided JSON
     */
    public static Service fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Service.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Service object using the provided
     * ObjectMapper.
     * 
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Service object represented by the provided JSON
     */
    public static Service fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Service.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI inboundRequestUrl;
    private final HttpMethod inboundMethod;
    private final URI fallbackUrl;
    private final HttpMethod fallbackMethod;
    private final URI statusCallback;
    private final Boolean stickySender;
    private final Boolean mmsConverter;
    private final Boolean smartEncoding;
    private final Service.ScanMessageContent scanMessageContent;
    private final Boolean fallbackToLongCode;
    private final Boolean areaCodeGeomatch;
    private final Boolean synchronousValidation;
    private final Integer validityPeriod;
    private final URI url;
    private final Map<String, String> links;

    @JsonCreator
    private Service(@JsonProperty("sid")
                    final String sid, 
                    @JsonProperty("account_sid")
                    final String accountSid, 
                    @JsonProperty("friendly_name")
                    final String friendlyName, 
                    @JsonProperty("date_created")
                    final String dateCreated, 
                    @JsonProperty("date_updated")
                    final String dateUpdated, 
                    @JsonProperty("inbound_request_url")
                    final URI inboundRequestUrl, 
                    @JsonProperty("inbound_method")
                    final HttpMethod inboundMethod, 
                    @JsonProperty("fallback_url")
                    final URI fallbackUrl, 
                    @JsonProperty("fallback_method")
                    final HttpMethod fallbackMethod, 
                    @JsonProperty("status_callback")
                    final URI statusCallback, 
                    @JsonProperty("sticky_sender")
                    final Boolean stickySender, 
                    @JsonProperty("mms_converter")
                    final Boolean mmsConverter, 
                    @JsonProperty("smart_encoding")
                    final Boolean smartEncoding, 
                    @JsonProperty("scan_message_content")
                    final Service.ScanMessageContent scanMessageContent, 
                    @JsonProperty("fallback_to_long_code")
                    final Boolean fallbackToLongCode, 
                    @JsonProperty("area_code_geomatch")
                    final Boolean areaCodeGeomatch, 
                    @JsonProperty("synchronous_validation")
                    final Boolean synchronousValidation, 
                    @JsonProperty("validity_period")
                    final Integer validityPeriod, 
                    @JsonProperty("url")
                    final URI url, 
                    @JsonProperty("links")
                    final Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.inboundRequestUrl = inboundRequestUrl;
        this.inboundMethod = inboundMethod;
        this.fallbackUrl = fallbackUrl;
        this.fallbackMethod = fallbackMethod;
        this.statusCallback = statusCallback;
        this.stickySender = stickySender;
        this.mmsConverter = mmsConverter;
        this.smartEncoding = smartEncoding;
        this.scanMessageContent = scanMessageContent;
        this.fallbackToLongCode = fallbackToLongCode;
        this.areaCodeGeomatch = areaCodeGeomatch;
        this.synchronousValidation = synchronousValidation;
        this.validityPeriod = validityPeriod;
        this.url = url;
        this.links = links;
    }

    /**
     * Returns The The sid.
     * 
     * @return The sid
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The The account_sid.
     * 
     * @return The account_sid
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The The friendly_name.
     * 
     * @return The friendly_name
     */
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    /**
     * Returns The The date_created.
     * 
     * @return The date_created
     */
    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The The date_updated.
     * 
     * @return The date_updated
     */
    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The The inbound_request_url.
     * 
     * @return The inbound_request_url
     */
    public final URI getInboundRequestUrl() {
        return this.inboundRequestUrl;
    }

    /**
     * Returns The The inbound_method.
     * 
     * @return The inbound_method
     */
    public final HttpMethod getInboundMethod() {
        return this.inboundMethod;
    }

    /**
     * Returns The The fallback_url.
     * 
     * @return The fallback_url
     */
    public final URI getFallbackUrl() {
        return this.fallbackUrl;
    }

    /**
     * Returns The The fallback_method.
     * 
     * @return The fallback_method
     */
    public final HttpMethod getFallbackMethod() {
        return this.fallbackMethod;
    }

    /**
     * Returns The The status_callback.
     * 
     * @return The status_callback
     */
    public final URI getStatusCallback() {
        return this.statusCallback;
    }

    /**
     * Returns The The sticky_sender.
     * 
     * @return The sticky_sender
     */
    public final Boolean getStickySender() {
        return this.stickySender;
    }

    /**
     * Returns The The mms_converter.
     * 
     * @return The mms_converter
     */
    public final Boolean getMmsConverter() {
        return this.mmsConverter;
    }

    /**
     * Returns The The smart_encoding.
     * 
     * @return The smart_encoding
     */
    public final Boolean getSmartEncoding() {
        return this.smartEncoding;
    }

    /**
     * Returns The The scan_message_content.
     * 
     * @return The scan_message_content
     */
    public final Service.ScanMessageContent getScanMessageContent() {
        return this.scanMessageContent;
    }

    /**
     * Returns The The fallback_to_long_code.
     * 
     * @return The fallback_to_long_code
     */
    public final Boolean getFallbackToLongCode() {
        return this.fallbackToLongCode;
    }

    /**
     * Returns The The area_code_geomatch.
     * 
     * @return The area_code_geomatch
     */
    public final Boolean getAreaCodeGeomatch() {
        return this.areaCodeGeomatch;
    }

    /**
     * Returns The The synchronous_validation.
     * 
     * @return The synchronous_validation
     */
    public final Boolean getSynchronousValidation() {
        return this.synchronousValidation;
    }

    /**
     * Returns The The validity_period.
     * 
     * @return The validity_period
     */
    public final Integer getValidityPeriod() {
        return this.validityPeriod;
    }

    /**
     * Returns The The url.
     * 
     * @return The url
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns The The links.
     * 
     * @return The links
     */
    public final Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Service other = (Service) o;

        return Objects.equals(sid, other.sid) && 
               Objects.equals(accountSid, other.accountSid) && 
               Objects.equals(friendlyName, other.friendlyName) && 
               Objects.equals(dateCreated, other.dateCreated) && 
               Objects.equals(dateUpdated, other.dateUpdated) && 
               Objects.equals(inboundRequestUrl, other.inboundRequestUrl) && 
               Objects.equals(inboundMethod, other.inboundMethod) && 
               Objects.equals(fallbackUrl, other.fallbackUrl) && 
               Objects.equals(fallbackMethod, other.fallbackMethod) && 
               Objects.equals(statusCallback, other.statusCallback) && 
               Objects.equals(stickySender, other.stickySender) && 
               Objects.equals(mmsConverter, other.mmsConverter) && 
               Objects.equals(smartEncoding, other.smartEncoding) && 
               Objects.equals(scanMessageContent, other.scanMessageContent) && 
               Objects.equals(fallbackToLongCode, other.fallbackToLongCode) && 
               Objects.equals(areaCodeGeomatch, other.areaCodeGeomatch) && 
               Objects.equals(synchronousValidation, other.synchronousValidation) && 
               Objects.equals(validityPeriod, other.validityPeriod) && 
               Objects.equals(url, other.url) && 
               Objects.equals(links, other.links);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            accountSid,
                            friendlyName,
                            dateCreated,
                            dateUpdated,
                            inboundRequestUrl,
                            inboundMethod,
                            fallbackUrl,
                            fallbackMethod,
                            statusCallback,
                            stickySender,
                            mmsConverter,
                            smartEncoding,
                            scanMessageContent,
                            fallbackToLongCode,
                            areaCodeGeomatch,
                            synchronousValidation,
                            validityPeriod,
                            url,
                            links);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                          .add("sid", sid)
                          .add("accountSid", accountSid)
                          .add("friendlyName", friendlyName)
                          .add("dateCreated", dateCreated)
                          .add("dateUpdated", dateUpdated)
                          .add("inboundRequestUrl", inboundRequestUrl)
                          .add("inboundMethod", inboundMethod)
                          .add("fallbackUrl", fallbackUrl)
                          .add("fallbackMethod", fallbackMethod)
                          .add("statusCallback", statusCallback)
                          .add("stickySender", stickySender)
                          .add("mmsConverter", mmsConverter)
                          .add("smartEncoding", smartEncoding)
                          .add("scanMessageContent", scanMessageContent)
                          .add("fallbackToLongCode", fallbackToLongCode)
                          .add("areaCodeGeomatch", areaCodeGeomatch)
                          .add("synchronousValidation", synchronousValidation)
                          .add("validityPeriod", validityPeriod)
                          .add("url", url)
                          .add("links", links)
                          .toString();
    }
}