/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.notify.v1.service;

import com.twilio.base.Creator;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.util.List;
import java.util.Map;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class NotificationCreator extends Creator<Notification> {
    private final String pathServiceSid;
    private List<String> identity;
    private List<String> tag;
    private String body;
    private Notification.Priority priority;
    private Integer ttl;
    private String title;
    private String sound;
    private String action;
    private Map<String, Object> data;
    private Map<String, Object> apn;
    private Map<String, Object> gcm;
    private Map<String, Object> sms;
    private Map<String, Object> facebookMessenger;
    private Map<String, Object> fcm;
    private List<String> segment;
    private Map<String, Object> alexa;
    private List<String> toBinding;

    /**
     * Construct a new NotificationCreator.
     * 
     * @param pathServiceSid The service_sid
     */
    public NotificationCreator(final String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    /**
     * The body.
     * 
     * @param body The body
     * @return this
     */
    public NotificationCreator setBody(final String body) {
        this.body = body;
        return this;
    }

    /**
     * The priority.
     * 
     * @param priority The priority
     * @return this
     */
    public NotificationCreator setPriority(final Notification.Priority priority) {
        this.priority = priority;
        return this;
    }

    /**
     * The ttl.
     * 
     * @param ttl The ttl
     * @return this
     */
    public NotificationCreator setTtl(final Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    /**
     * The title.
     * 
     * @param title The title
     * @return this
     */
    public NotificationCreator setTitle(final String title) {
        this.title = title;
        return this;
    }

    /**
     * The sound.
     * 
     * @param sound The sound
     * @return this
     */
    public NotificationCreator setSound(final String sound) {
        this.sound = sound;
        return this;
    }

    /**
     * The action.
     * 
     * @param action The action
     * @return this
     */
    public NotificationCreator setAction(final String action) {
        this.action = action;
        return this;
    }

    /**
     * The data.
     * 
     * @param data The data
     * @return this
     */
    public NotificationCreator setData(final Map<String, Object> data) {
        this.data = data;
        return this;
    }

    /**
     * The apn.
     * 
     * @param apn The apn
     * @return this
     */
    public NotificationCreator setApn(final Map<String, Object> apn) {
        this.apn = apn;
        return this;
    }

    /**
     * The gcm.
     * 
     * @param gcm The gcm
     * @return this
     */
    public NotificationCreator setGcm(final Map<String, Object> gcm) {
        this.gcm = gcm;
        return this;
    }

    /**
     * The sms.
     * 
     * @param sms The sms
     * @return this
     */
    public NotificationCreator setSms(final Map<String, Object> sms) {
        this.sms = sms;
        return this;
    }

    /**
     * The facebook_messenger.
     * 
     * @param facebookMessenger The facebook_messenger
     * @return this
     */
    public NotificationCreator setFacebookMessenger(final Map<String, Object> facebookMessenger) {
        this.facebookMessenger = facebookMessenger;
        return this;
    }

    /**
     * The fcm.
     * 
     * @param fcm The fcm
     * @return this
     */
    public NotificationCreator setFcm(final Map<String, Object> fcm) {
        this.fcm = fcm;
        return this;
    }

    /**
     * The segment.
     * 
     * @param segment The segment
     * @return this
     */
    public NotificationCreator setSegment(final List<String> segment) {
        this.segment = segment;
        return this;
    }

    /**
     * The segment.
     * 
     * @param segment The segment
     * @return this
     */
    public NotificationCreator setSegment(final String segment) {
        return setSegment(Promoter.listOfOne(segment));
    }

    /**
     * The alexa.
     * 
     * @param alexa The alexa
     * @return this
     */
    public NotificationCreator setAlexa(final Map<String, Object> alexa) {
        this.alexa = alexa;
        return this;
    }

    /**
     * The to_binding.
     * 
     * @param toBinding The to_binding
     * @return this
     */
    public NotificationCreator setToBinding(final List<String> toBinding) {
        this.toBinding = toBinding;
        return this;
    }

    /**
     * The to_binding.
     * 
     * @param toBinding The to_binding
     * @return this
     */
    public NotificationCreator setToBinding(final String toBinding) {
        return setToBinding(Promoter.listOfOne(toBinding));
    }

    /**
     * The identity.
     * 
     * @param identity The identity
     * @return this
     */
    public NotificationCreator setIdentity(final List<String> identity) {
        this.identity = identity;
        return this;
    }

    /**
     * The identity.
     * 
     * @param identity The identity
     * @return this
     */
    public NotificationCreator setIdentity(final String identity) {
        return setIdentity(Promoter.listOfOne(identity));
    }

    /**
     * The tag.
     * 
     * @param tag The tag
     * @return this
     */
    public NotificationCreator setTag(final List<String> tag) {
        this.tag = tag;
        return this;
    }

    /**
     * The tag.
     * 
     * @param tag The tag
     * @return this
     */
    public NotificationCreator setTag(final String tag) {
        return setTag(Promoter.listOfOne(tag));
    }

    /**
     * Make the request to the Twilio API to perform the create.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return Created Notification
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Notification create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.NOTIFY.toString(),
            "/v1/Services/" + this.pathServiceSid + "/Notifications",
            client.getRegion()
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Notification creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }

            throw new ApiException(
                restException.getMessage(),
                restException.getCode(),
                restException.getMoreInfo(),
                restException.getStatus(),
                null
            );
        }

        return Notification.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     * 
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (identity != null) {
            for (String prop : identity) {
                request.addPostParam("Identity", prop);
            }
        }

        if (tag != null) {
            for (String prop : tag) {
                request.addPostParam("Tag", prop);
            }
        }

        if (body != null) {
            request.addPostParam("Body", body);
        }

        if (priority != null) {
            request.addPostParam("Priority", priority.toString());
        }

        if (ttl != null) {
            request.addPostParam("Ttl", ttl.toString());
        }

        if (title != null) {
            request.addPostParam("Title", title);
        }

        if (sound != null) {
            request.addPostParam("Sound", sound);
        }

        if (action != null) {
            request.addPostParam("Action", action);
        }

        if (data != null) {
            request.addPostParam("Data", Converter.mapToJson(data));
        }

        if (apn != null) {
            request.addPostParam("Apn", Converter.mapToJson(apn));
        }

        if (gcm != null) {
            request.addPostParam("Gcm", Converter.mapToJson(gcm));
        }

        if (sms != null) {
            request.addPostParam("Sms", Converter.mapToJson(sms));
        }

        if (facebookMessenger != null) {
            request.addPostParam("FacebookMessenger", Converter.mapToJson(facebookMessenger));
        }

        if (fcm != null) {
            request.addPostParam("Fcm", Converter.mapToJson(fcm));
        }

        if (segment != null) {
            for (String prop : segment) {
                request.addPostParam("Segment", prop);
            }
        }

        if (alexa != null) {
            request.addPostParam("Alexa", Converter.mapToJson(alexa));
        }

        if (toBinding != null) {
            for (String prop : toBinding) {
                request.addPostParam("ToBinding", prop);
            }
        }
    }
}