/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.notify.v1.service.user;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class SegmentMembershipCreator extends Creator<SegmentMembership> {
    private final String pathServiceSid;
    private final String pathIdentity;
    private final String segment;

    /**
     * Construct a new SegmentMembershipCreator.
     * 
     * @param pathServiceSid The service_sid
     * @param pathIdentity The identity
     * @param segment The segment
     */
    public SegmentMembershipCreator(final String pathServiceSid, 
                                    final String pathIdentity, 
                                    final String segment) {
        this.pathServiceSid = pathServiceSid;
        this.pathIdentity = pathIdentity;
        this.segment = segment;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return Created SegmentMembership
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public SegmentMembership create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.NOTIFY.toString(),
            "/v1/Services/" + this.pathServiceSid + "/Users/" + this.pathIdentity + "/SegmentMemberships",
            client.getRegion()
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("SegmentMembership creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }

            throw new ApiException(
                restException.getMessage(),
                restException.getCode(),
                restException.getMoreInfo(),
                restException.getStatus(),
                null
            );
        }

        return SegmentMembership.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     * 
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (segment != null) {
            request.addPostParam("Segment", segment);
        }
    }
}