/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.notify.v1.service.user;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.util.List;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class UserBindingCreator extends Creator<UserBinding> {
    private final String pathServiceSid;
    private final String pathIdentity;
    private final UserBinding.BindingType bindingType;
    private final String address;
    private List<String> tag;
    private String notificationProtocolVersion;
    private String credentialSid;
    private String endpoint;

    /**
     * Construct a new UserBindingCreator.
     * 
     * @param pathServiceSid The service_sid
     * @param pathIdentity The identity
     * @param bindingType The binding_type
     * @param address The address
     */
    public UserBindingCreator(final String pathServiceSid, 
                              final String pathIdentity, 
                              final UserBinding.BindingType bindingType, 
                              final String address) {
        this.pathServiceSid = pathServiceSid;
        this.pathIdentity = pathIdentity;
        this.bindingType = bindingType;
        this.address = address;
    }

    /**
     * The tag.
     * 
     * @param tag The tag
     * @return this
     */
    public UserBindingCreator setTag(final List<String> tag) {
        this.tag = tag;
        return this;
    }

    /**
     * The tag.
     * 
     * @param tag The tag
     * @return this
     */
    public UserBindingCreator setTag(final String tag) {
        return setTag(Promoter.listOfOne(tag));
    }

    /**
     * The notification_protocol_version.
     * 
     * @param notificationProtocolVersion The notification_protocol_version
     * @return this
     */
    public UserBindingCreator setNotificationProtocolVersion(final String notificationProtocolVersion) {
        this.notificationProtocolVersion = notificationProtocolVersion;
        return this;
    }

    /**
     * The credential_sid.
     * 
     * @param credentialSid The credential_sid
     * @return this
     */
    public UserBindingCreator setCredentialSid(final String credentialSid) {
        this.credentialSid = credentialSid;
        return this;
    }

    /**
     * The endpoint.
     * 
     * @param endpoint The endpoint
     * @return this
     */
    public UserBindingCreator setEndpoint(final String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return Created UserBinding
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public UserBinding create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.NOTIFY.toString(),
            "/v1/Services/" + this.pathServiceSid + "/Users/" + this.pathIdentity + "/Bindings",
            client.getRegion()
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("UserBinding creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }

            throw new ApiException(
                restException.getMessage(),
                restException.getCode(),
                restException.getMoreInfo(),
                restException.getStatus(),
                null
            );
        }

        return UserBinding.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     * 
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (bindingType != null) {
            request.addPostParam("BindingType", bindingType.toString());
        }

        if (address != null) {
            request.addPostParam("Address", address);
        }

        if (tag != null) {
            for (String prop : tag) {
                request.addPostParam("Tag", prop);
            }
        }

        if (notificationProtocolVersion != null) {
            request.addPostParam("NotificationProtocolVersion", notificationProtocolVersion);
        }

        if (credentialSid != null) {
            request.addPostParam("CredentialSid", credentialSid);
        }

        if (endpoint != null) {
            request.addPostParam("Endpoint", endpoint);
        }
    }
}