/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.deployedDevices;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
public class FleetUpdater extends Updater<Fleet> {
    private final String pathSid;
    private String friendlyName;
    private String defaultDeploymentSid;

    /**
     * Construct a new FleetUpdater.
     * 
     * @param pathSid A string that uniquely identifies the Fleet.
     */
    public FleetUpdater(final String pathSid) {
        this.pathSid = pathSid;
    }

    /**
     * Provides a human readable descriptive text for this Fleet, up to 256
     * characters long..
     * 
     * @param friendlyName A human readable description for this Fleet.
     * @return this
     */
    public FleetUpdater setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    /**
     * Provides a string identifier of a Deployment that is going to be used as a
     * default one for this Fleet..
     * 
     * @param defaultDeploymentSid A default Deployment SID.
     * @return this
     */
    public FleetUpdater setDefaultDeploymentSid(final String defaultDeploymentSid) {
        this.defaultDeploymentSid = defaultDeploymentSid;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return Updated Fleet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Fleet update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.PREVIEW.toString(),
            "/DeployedDevices/Fleets/" + this.pathSid + "",
            client.getRegion()
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Fleet update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }

            throw new ApiException(
                restException.getMessage(),
                restException.getCode(),
                restException.getMoreInfo(),
                restException.getStatus(),
                null
            );
        }

        return Fleet.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     * 
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (defaultDeploymentSid != null) {
            request.addPostParam("DefaultDeploymentSid", defaultDeploymentSid);
        }
    }
}