/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.deployedDevices.fleet;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
public class DeviceUpdater extends Updater<Device> {
    private final String pathFleetSid;
    private final String pathSid;
    private String friendlyName;
    private String identity;
    private String deploymentSid;
    private Boolean enabled;

    /**
     * Construct a new DeviceUpdater.
     * 
     * @param pathFleetSid The fleet_sid
     * @param pathSid A string that uniquely identifies the Device.
     */
    public DeviceUpdater(final String pathFleetSid, 
                         final String pathSid) {
        this.pathFleetSid = pathFleetSid;
        this.pathSid = pathSid;
    }

    /**
     * Provides a human readable descriptive text to be assigned to this Device, up
     * to 256 characters long..
     * 
     * @param friendlyName A human readable description for this Device.
     * @return this
     */
    public DeviceUpdater setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    /**
     * Provides an arbitrary string identifier representing a human user to be
     * associated with this Device, up to 256 characters long..
     * 
     * @param identity An identifier of the Device user.
     * @return this
     */
    public DeviceUpdater setIdentity(final String identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Specifies the unique string identifier of the Deployment group that this
     * Device is going to be associated with..
     * 
     * @param deploymentSid The unique SID of the Deployment group.
     * @return this
     */
    public DeviceUpdater setDeploymentSid(final String deploymentSid) {
        this.deploymentSid = deploymentSid;
        return this;
    }

    /**
     * The enabled.
     * 
     * @param enabled The enabled
     * @return this
     */
    public DeviceUpdater setEnabled(final Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return Updated Device
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Device update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.PREVIEW.toString(),
            "/DeployedDevices/Fleets/" + this.pathFleetSid + "/Devices/" + this.pathSid + "",
            client.getRegion()
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Device update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }

            throw new ApiException(
                restException.getMessage(),
                restException.getCode(),
                restException.getMoreInfo(),
                restException.getStatus(),
                null
            );
        }

        return Device.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     * 
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (identity != null) {
            request.addPostParam("Identity", identity);
        }

        if (deploymentSid != null) {
            request.addPostParam("DeploymentSid", deploymentSid);
        }

        if (enabled != null) {
            request.addPostParam("Enabled", enabled.toString());
        }
    }
}