/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.hostedNumbers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.type.PhoneNumberCapabilities;
import org.joda.time.DateTime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class HostedNumberOrder extends Resource {
    private static final long serialVersionUID = 273092781006289L;

    public enum Status {
        RECEIVED("received"),
        PENDING_VERIFICATION("pending-verification"),
        VERIFIED("verified"),
        PENDING_LOA("pending-loa"),
        CARRIER_PROCESSING("carrier-processing"),
        TESTING("testing"),
        COMPLETED("completed"),
        FAILED("failed"),
        ACTION_REQUIRED("action-required");

        private final String value;

        private Status(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Status from a string.
         * @param value string value
         * @return generated Status
         */
        @JsonCreator
        public static Status forValue(final String value) {
            return Promoter.enumFromString(value, Status.values());
        }
    }

    public enum VerificationType {
        PHONE_CALL("phone-call"),
        PHONE_BILL("phone-bill");

        private final String value;

        private VerificationType(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a VerificationType from a string.
         * @param value string value
         * @return generated VerificationType
         */
        @JsonCreator
        public static VerificationType forValue(final String value) {
            return Promoter.enumFromString(value, VerificationType.values());
        }
    }

    /**
     * Create a HostedNumberOrderFetcher to execute fetch.
     * 
     * @param pathSid HostedNumberOrder sid.
     * @return HostedNumberOrderFetcher capable of executing the fetch
     */
    public static HostedNumberOrderFetcher fetcher(final String pathSid) {
        return new HostedNumberOrderFetcher(pathSid);
    }

    /**
     * Create a HostedNumberOrderDeleter to execute delete.
     * 
     * @param pathSid HostedNumberOrder sid.
     * @return HostedNumberOrderDeleter capable of executing the delete
     */
    public static HostedNumberOrderDeleter deleter(final String pathSid) {
        return new HostedNumberOrderDeleter(pathSid);
    }

    /**
     * Create a HostedNumberOrderUpdater to execute update.
     * 
     * @param pathSid The sid
     * @return HostedNumberOrderUpdater capable of executing the update
     */
    public static HostedNumberOrderUpdater updater(final String pathSid) {
        return new HostedNumberOrderUpdater(pathSid);
    }

    /**
     * Create a HostedNumberOrderReader to execute read.
     * 
     * @return HostedNumberOrderReader capable of executing the read
     */
    public static HostedNumberOrderReader reader() {
        return new HostedNumberOrderReader();
    }

    /**
     * Create a HostedNumberOrderCreator to execute create.
     * 
     * @param phoneNumber An E164 formatted phone number.
     * @param smsCapability Specify SMS capability to host.
     * @return HostedNumberOrderCreator capable of executing the create
     */
    public static HostedNumberOrderCreator creator(final com.twilio.type.PhoneNumber phoneNumber, 
                                                   final Boolean smsCapability) {
        return new HostedNumberOrderCreator(phoneNumber, smsCapability);
    }

    /**
     * Converts a JSON String into a HostedNumberOrder object using the provided
     * ObjectMapper.
     * 
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return HostedNumberOrder object represented by the provided JSON
     */
    public static HostedNumberOrder fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, HostedNumberOrder.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a HostedNumberOrder object using the
     * provided ObjectMapper.
     * 
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return HostedNumberOrder object represented by the provided JSON
     */
    public static HostedNumberOrder fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, HostedNumberOrder.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String accountSid;
    private final String incomingPhoneNumberSid;
    private final String addressSid;
    private final String signingDocumentSid;
    private final com.twilio.type.PhoneNumber phoneNumber;
    private final PhoneNumberCapabilities capabilities;
    private final String friendlyName;
    private final String uniqueName;
    private final HostedNumberOrder.Status status;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Integer verificationAttempts;
    private final String email;
    private final List<String> ccEmails;
    private final URI url;
    private final HostedNumberOrder.VerificationType verificationType;
    private final String verificationDocumentSid;

    @JsonCreator
    private HostedNumberOrder(@JsonProperty("sid")
                              final String sid, 
                              @JsonProperty("account_sid")
                              final String accountSid, 
                              @JsonProperty("incoming_phone_number_sid")
                              final String incomingPhoneNumberSid, 
                              @JsonProperty("address_sid")
                              final String addressSid, 
                              @JsonProperty("signing_document_sid")
                              final String signingDocumentSid, 
                              @JsonProperty("phone_number")
                              final com.twilio.type.PhoneNumber phoneNumber, 
                              @JsonProperty("capabilities")
                              final PhoneNumberCapabilities capabilities, 
                              @JsonProperty("friendly_name")
                              final String friendlyName, 
                              @JsonProperty("unique_name")
                              final String uniqueName, 
                              @JsonProperty("status")
                              final HostedNumberOrder.Status status, 
                              @JsonProperty("date_created")
                              final String dateCreated, 
                              @JsonProperty("date_updated")
                              final String dateUpdated, 
                              @JsonProperty("verification_attempts")
                              final Integer verificationAttempts, 
                              @JsonProperty("email")
                              final String email, 
                              @JsonProperty("cc_emails")
                              final List<String> ccEmails, 
                              @JsonProperty("url")
                              final URI url, 
                              @JsonProperty("verification_type")
                              final HostedNumberOrder.VerificationType verificationType, 
                              @JsonProperty("verification_document_sid")
                              final String verificationDocumentSid) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.incomingPhoneNumberSid = incomingPhoneNumberSid;
        this.addressSid = addressSid;
        this.signingDocumentSid = signingDocumentSid;
        this.phoneNumber = phoneNumber;
        this.capabilities = capabilities;
        this.friendlyName = friendlyName;
        this.uniqueName = uniqueName;
        this.status = status;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.verificationAttempts = verificationAttempts;
        this.email = email;
        this.ccEmails = ccEmails;
        this.url = url;
        this.verificationType = verificationType;
        this.verificationDocumentSid = verificationDocumentSid;
    }

    /**
     * Returns The HostedNumberOrder sid..
     * 
     * @return HostedNumberOrder sid.
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The Account Sid..
     * 
     * @return Account Sid.
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The IncomingPhoneNumber sid..
     * 
     * @return IncomingPhoneNumber sid.
     */
    public final String getIncomingPhoneNumberSid() {
        return this.incomingPhoneNumberSid;
    }

    /**
     * Returns The Address sid..
     * 
     * @return Address sid.
     */
    public final String getAddressSid() {
        return this.addressSid;
    }

    /**
     * Returns The LOA document sid..
     * 
     * @return LOA document sid.
     */
    public final String getSigningDocumentSid() {
        return this.signingDocumentSid;
    }

    /**
     * Returns The An E164 formatted phone number..
     * 
     * @return An E164 formatted phone number.
     */
    public final com.twilio.type.PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    /**
     * Returns The A mapping of phone number capabilities..
     * 
     * @return A mapping of phone number capabilities.
     */
    public final PhoneNumberCapabilities getCapabilities() {
        return this.capabilities;
    }

    /**
     * Returns The A human readable description of this resource..
     * 
     * @return A human readable description of this resource.
     */
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    /**
     * Returns The A unique, developer assigned name of this HostedNumberOrder..
     * 
     * @return A unique, developer assigned name of this HostedNumberOrder.
     */
    public final String getUniqueName() {
        return this.uniqueName;
    }

    /**
     * Returns The The Status of this HostedNumberOrder..
     * 
     * @return The Status of this HostedNumberOrder.
     */
    public final HostedNumberOrder.Status getStatus() {
        return this.status;
    }

    /**
     * Returns The The date this HostedNumberOrder was created..
     * 
     * @return The date this HostedNumberOrder was created.
     */
    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The The date this HostedNumberOrder was updated..
     * 
     * @return The date this HostedNumberOrder was updated.
     */
    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The The number of verification attempts made to verify ownership of
     * the phone number..
     * 
     * @return The number of verification attempts made to verify ownership of the
     *         phone number.
     */
    public final Integer getVerificationAttempts() {
        return this.verificationAttempts;
    }

    /**
     * Returns The Email..
     * 
     * @return Email.
     */
    public final String getEmail() {
        return this.email;
    }

    /**
     * Returns The A list of emails..
     * 
     * @return A list of emails.
     */
    public final List<String> getCcEmails() {
        return this.ccEmails;
    }

    /**
     * Returns The The URL of this HostedNumberOrder..
     * 
     * @return The URL of this HostedNumberOrder.
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns The The method used for verifying ownership of the number to be
     * hosted..
     * 
     * @return The method used for verifying ownership of the number to be hosted.
     */
    public final HostedNumberOrder.VerificationType getVerificationType() {
        return this.verificationType;
    }

    /**
     * Returns The Verification Document Sid..
     * 
     * @return Verification Document Sid.
     */
    public final String getVerificationDocumentSid() {
        return this.verificationDocumentSid;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        HostedNumberOrder other = (HostedNumberOrder) o;

        return Objects.equals(sid, other.sid) && 
               Objects.equals(accountSid, other.accountSid) && 
               Objects.equals(incomingPhoneNumberSid, other.incomingPhoneNumberSid) && 
               Objects.equals(addressSid, other.addressSid) && 
               Objects.equals(signingDocumentSid, other.signingDocumentSid) && 
               Objects.equals(phoneNumber, other.phoneNumber) && 
               Objects.equals(capabilities, other.capabilities) && 
               Objects.equals(friendlyName, other.friendlyName) && 
               Objects.equals(uniqueName, other.uniqueName) && 
               Objects.equals(status, other.status) && 
               Objects.equals(dateCreated, other.dateCreated) && 
               Objects.equals(dateUpdated, other.dateUpdated) && 
               Objects.equals(verificationAttempts, other.verificationAttempts) && 
               Objects.equals(email, other.email) && 
               Objects.equals(ccEmails, other.ccEmails) && 
               Objects.equals(url, other.url) && 
               Objects.equals(verificationType, other.verificationType) && 
               Objects.equals(verificationDocumentSid, other.verificationDocumentSid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            accountSid,
                            incomingPhoneNumberSid,
                            addressSid,
                            signingDocumentSid,
                            phoneNumber,
                            capabilities,
                            friendlyName,
                            uniqueName,
                            status,
                            dateCreated,
                            dateUpdated,
                            verificationAttempts,
                            email,
                            ccEmails,
                            url,
                            verificationType,
                            verificationDocumentSid);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                          .add("sid", sid)
                          .add("accountSid", accountSid)
                          .add("incomingPhoneNumberSid", incomingPhoneNumberSid)
                          .add("addressSid", addressSid)
                          .add("signingDocumentSid", signingDocumentSid)
                          .add("phoneNumber", phoneNumber)
                          .add("capabilities", capabilities)
                          .add("friendlyName", friendlyName)
                          .add("uniqueName", uniqueName)
                          .add("status", status)
                          .add("dateCreated", dateCreated)
                          .add("dateUpdated", dateUpdated)
                          .add("verificationAttempts", verificationAttempts)
                          .add("email", email)
                          .add("ccEmails", ccEmails)
                          .add("url", url)
                          .add("verificationType", verificationType)
                          .add("verificationDocumentSid", verificationDocumentSid)
                          .toString();
    }
}