/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.marketplace.installedaddon;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class InstalledAddOnExtension extends Resource {
    private static final long serialVersionUID = 70024747231532L;

    /**
     * Create a InstalledAddOnExtensionFetcher to execute fetch.
     * 
     * @param pathInstalledAddOnSid The installed_add_on_sid
     * @param pathSid The unique Extension Sid
     * @return InstalledAddOnExtensionFetcher capable of executing the fetch
     */
    public static InstalledAddOnExtensionFetcher fetcher(final String pathInstalledAddOnSid, 
                                                         final String pathSid) {
        return new InstalledAddOnExtensionFetcher(pathInstalledAddOnSid, pathSid);
    }

    /**
     * Create a InstalledAddOnExtensionUpdater to execute update.
     * 
     * @param pathInstalledAddOnSid The installed_add_on_sid
     * @param pathSid The sid
     * @param enabled A Boolean indicating if the Extension will be invoked
     * @return InstalledAddOnExtensionUpdater capable of executing the update
     */
    public static InstalledAddOnExtensionUpdater updater(final String pathInstalledAddOnSid, 
                                                         final String pathSid, 
                                                         final Boolean enabled) {
        return new InstalledAddOnExtensionUpdater(pathInstalledAddOnSid, pathSid, enabled);
    }

    /**
     * Create a InstalledAddOnExtensionReader to execute read.
     * 
     * @param pathInstalledAddOnSid The installed_add_on_sid
     * @return InstalledAddOnExtensionReader capable of executing the read
     */
    public static InstalledAddOnExtensionReader reader(final String pathInstalledAddOnSid) {
        return new InstalledAddOnExtensionReader(pathInstalledAddOnSid);
    }

    /**
     * Converts a JSON String into a InstalledAddOnExtension object using the
     * provided ObjectMapper.
     * 
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return InstalledAddOnExtension object represented by the provided JSON
     */
    public static InstalledAddOnExtension fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, InstalledAddOnExtension.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a InstalledAddOnExtension object using the
     * provided ObjectMapper.
     * 
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return InstalledAddOnExtension object represented by the provided JSON
     */
    public static InstalledAddOnExtension fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, InstalledAddOnExtension.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String installedAddOnSid;
    private final String friendlyName;
    private final String productName;
    private final String uniqueName;
    private final Boolean enabled;
    private final URI url;

    @JsonCreator
    private InstalledAddOnExtension(@JsonProperty("sid")
                                    final String sid, 
                                    @JsonProperty("installed_add_on_sid")
                                    final String installedAddOnSid, 
                                    @JsonProperty("friendly_name")
                                    final String friendlyName, 
                                    @JsonProperty("product_name")
                                    final String productName, 
                                    @JsonProperty("unique_name")
                                    final String uniqueName, 
                                    @JsonProperty("enabled")
                                    final Boolean enabled, 
                                    @JsonProperty("url")
                                    final URI url) {
        this.sid = sid;
        this.installedAddOnSid = installedAddOnSid;
        this.friendlyName = friendlyName;
        this.productName = productName;
        this.uniqueName = uniqueName;
        this.enabled = enabled;
        this.url = url;
    }

    /**
     * Returns The A string that uniquely identifies this Extension.
     * 
     * @return A string that uniquely identifies this Extension
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The The installed_add_on_sid.
     * 
     * @return The installed_add_on_sid
     */
    public final String getInstalledAddOnSid() {
        return this.installedAddOnSid;
    }

    /**
     * Returns The A human-readable description of this Extension.
     * 
     * @return A human-readable description of this Extension
     */
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    /**
     * Returns The A human-readable description of the Extension's Product.
     * 
     * @return A human-readable description of the Extension's Product
     */
    public final String getProductName() {
        return this.productName;
    }

    /**
     * Returns The The string that uniquely identifies this Extension.
     * 
     * @return The string that uniquely identifies this Extension
     */
    public final String getUniqueName() {
        return this.uniqueName;
    }

    /**
     * Returns The A Boolean indicating if the Extension will be invoked.
     * 
     * @return A Boolean indicating if the Extension will be invoked
     */
    public final Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * Returns The The url.
     * 
     * @return The url
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        InstalledAddOnExtension other = (InstalledAddOnExtension) o;

        return Objects.equals(sid, other.sid) && 
               Objects.equals(installedAddOnSid, other.installedAddOnSid) && 
               Objects.equals(friendlyName, other.friendlyName) && 
               Objects.equals(productName, other.productName) && 
               Objects.equals(uniqueName, other.uniqueName) && 
               Objects.equals(enabled, other.enabled) && 
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            installedAddOnSid,
                            friendlyName,
                            productName,
                            uniqueName,
                            enabled,
                            url);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                          .add("sid", sid)
                          .add("installedAddOnSid", installedAddOnSid)
                          .add("friendlyName", friendlyName)
                          .add("productName", productName)
                          .add("uniqueName", uniqueName)
                          .add("enabled", enabled)
                          .add("url", url)
                          .toString();
    }
}