/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.studio.flow;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import org.joda.time.DateTime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Engagement extends Resource {
    private static final long serialVersionUID = 59724732183846L;

    public enum Status {
        ACTIVE("active"),
        ENDED("ended");

        private final String value;

        private Status(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Status from a string.
         * @param value string value
         * @return generated Status
         */
        @JsonCreator
        public static Status forValue(final String value) {
            return Promoter.enumFromString(value, Status.values());
        }
    }

    /**
     * Create a EngagementReader to execute read.
     * 
     * @param pathFlowSid Flow Sid.
     * @return EngagementReader capable of executing the read
     */
    public static EngagementReader reader(final String pathFlowSid) {
        return new EngagementReader(pathFlowSid);
    }

    /**
     * Create a EngagementFetcher to execute fetch.
     * 
     * @param pathFlowSid The flow_sid
     * @param pathSid The sid
     * @return EngagementFetcher capable of executing the fetch
     */
    public static EngagementFetcher fetcher(final String pathFlowSid, 
                                            final String pathSid) {
        return new EngagementFetcher(pathFlowSid, pathSid);
    }

    /**
     * Create a EngagementCreator to execute create.
     * 
     * @param pathFlowSid Flow Sid.
     * @param to The to
     * @param from The from
     * @return EngagementCreator capable of executing the create
     */
    public static EngagementCreator creator(final String pathFlowSid, 
                                            final com.twilio.type.PhoneNumber to, 
                                            final com.twilio.type.PhoneNumber from) {
        return new EngagementCreator(pathFlowSid, to, from);
    }

    /**
     * Create a EngagementDeleter to execute delete.
     * 
     * @param pathFlowSid Flow Sid.
     * @param pathSid A string that uniquely identifies this Engagement.
     * @return EngagementDeleter capable of executing the delete
     */
    public static EngagementDeleter deleter(final String pathFlowSid, 
                                            final String pathSid) {
        return new EngagementDeleter(pathFlowSid, pathSid);
    }

    /**
     * Converts a JSON String into a Engagement object using the provided
     * ObjectMapper.
     * 
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Engagement object represented by the provided JSON
     */
    public static Engagement fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Engagement.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Engagement object using the provided
     * ObjectMapper.
     * 
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Engagement object represented by the provided JSON
     */
    public static Engagement fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Engagement.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String accountSid;
    private final String flowSid;
    private final String contactSid;
    private final com.twilio.type.PhoneNumber contactChannelAddress;
    private final Engagement.Status status;
    private final Map<String, Object> context;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    @JsonCreator
    private Engagement(@JsonProperty("sid")
                       final String sid, 
                       @JsonProperty("account_sid")
                       final String accountSid, 
                       @JsonProperty("flow_sid")
                       final String flowSid, 
                       @JsonProperty("contact_sid")
                       final String contactSid, 
                       @JsonProperty("contact_channel_address")
                       final com.twilio.type.PhoneNumber contactChannelAddress, 
                       @JsonProperty("status")
                       final Engagement.Status status, 
                       @JsonProperty("context")
                       final Map<String, Object> context, 
                       @JsonProperty("date_created")
                       final String dateCreated, 
                       @JsonProperty("date_updated")
                       final String dateUpdated, 
                       @JsonProperty("url")
                       final URI url, 
                       @JsonProperty("links")
                       final Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.flowSid = flowSid;
        this.contactSid = contactSid;
        this.contactChannelAddress = contactChannelAddress;
        this.status = status;
        this.context = context;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    /**
     * Returns The A string that uniquely identifies this Engagement..
     * 
     * @return A string that uniquely identifies this Engagement.
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The Account Sid..
     * 
     * @return Account Sid.
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The Flow Sid..
     * 
     * @return Flow Sid.
     */
    public final String getFlowSid() {
        return this.flowSid;
    }

    /**
     * Returns The Contact Sid..
     * 
     * @return Contact Sid.
     */
    public final String getContactSid() {
        return this.contactSid;
    }

    /**
     * Returns The The phone number, SIP address or Client identifier that triggered
     * this Engagement..
     * 
     * @return The phone number, SIP address or Client identifier that triggered
     *         this Engagement.
     */
    public final com.twilio.type.PhoneNumber getContactChannelAddress() {
        return this.contactChannelAddress;
    }

    /**
     * Returns The The Status of this Engagement.
     * 
     * @return The Status of this Engagement
     */
    public final Engagement.Status getStatus() {
        return this.status;
    }

    /**
     * Returns The Nested resource URLs..
     * 
     * @return Nested resource URLs.
     */
    public final Map<String, Object> getContext() {
        return this.context;
    }

    /**
     * Returns The The date this Engagement was created.
     * 
     * @return The date this Engagement was created
     */
    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The The date this Engagement was updated.
     * 
     * @return The date this Engagement was updated
     */
    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The The URL of this resource..
     * 
     * @return The URL of this resource.
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns The Nested resource URLs..
     * 
     * @return Nested resource URLs.
     */
    public final Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Engagement other = (Engagement) o;

        return Objects.equals(sid, other.sid) && 
               Objects.equals(accountSid, other.accountSid) && 
               Objects.equals(flowSid, other.flowSid) && 
               Objects.equals(contactSid, other.contactSid) && 
               Objects.equals(contactChannelAddress, other.contactChannelAddress) && 
               Objects.equals(status, other.status) && 
               Objects.equals(context, other.context) && 
               Objects.equals(dateCreated, other.dateCreated) && 
               Objects.equals(dateUpdated, other.dateUpdated) && 
               Objects.equals(url, other.url) && 
               Objects.equals(links, other.links);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            accountSid,
                            flowSid,
                            contactSid,
                            contactChannelAddress,
                            status,
                            context,
                            dateCreated,
                            dateUpdated,
                            url,
                            links);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                          .add("sid", sid)
                          .add("accountSid", accountSid)
                          .add("flowSid", flowSid)
                          .add("contactSid", contactSid)
                          .add("contactChannelAddress", contactChannelAddress)
                          .add("status", status)
                          .add("context", context)
                          .add("dateCreated", dateCreated)
                          .add("dateUpdated", dateUpdated)
                          .add("url", url)
                          .add("links", links)
                          .toString();
    }
}