/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.studio.flow;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
public class EngagementCreator extends Creator<Engagement> {
    private final String pathFlowSid;
    private final com.twilio.type.PhoneNumber to;
    private final com.twilio.type.PhoneNumber from;
    private String parameters;

    /**
     * Construct a new EngagementCreator.
     * 
     * @param pathFlowSid Flow Sid.
     * @param to The to
     * @param from The from
     */
    public EngagementCreator(final String pathFlowSid, 
                             final com.twilio.type.PhoneNumber to, 
                             final com.twilio.type.PhoneNumber from) {
        this.pathFlowSid = pathFlowSid;
        this.to = to;
        this.from = from;
    }

    /**
     * The parameters.
     * 
     * @param parameters The parameters
     * @return this
     */
    public EngagementCreator setParameters(final String parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return Created Engagement
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Engagement create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.PREVIEW.toString(),
            "/Studio/Flows/" + this.pathFlowSid + "/Engagements",
            client.getRegion()
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Engagement creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }

            throw new ApiException(
                restException.getMessage(),
                restException.getCode(),
                restException.getMoreInfo(),
                restException.getStatus(),
                null
            );
        }

        return Engagement.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     * 
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (to != null) {
            request.addPostParam("To", to.toString());
        }

        if (from != null) {
            request.addPostParam("From", from.toString());
        }

        if (parameters != null) {
            request.addPostParam("Parameters", parameters);
        }
    }
}