/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.understand.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import org.joda.time.DateTime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Query extends Resource {
    private static final long serialVersionUID = 93828254756493L;

    /**
     * Create a QueryFetcher to execute fetch.
     * 
     * @param pathServiceSid The service_sid
     * @param pathSid The sid
     * @return QueryFetcher capable of executing the fetch
     */
    public static QueryFetcher fetcher(final String pathServiceSid, 
                                       final String pathSid) {
        return new QueryFetcher(pathServiceSid, pathSid);
    }

    /**
     * Create a QueryReader to execute read.
     * 
     * @param pathServiceSid The service_sid
     * @return QueryReader capable of executing the read
     */
    public static QueryReader reader(final String pathServiceSid) {
        return new QueryReader(pathServiceSid);
    }

    /**
     * Create a QueryCreator to execute create.
     * 
     * @param pathServiceSid The service_sid
     * @param language The language
     * @param query The query
     * @return QueryCreator capable of executing the create
     */
    public static QueryCreator creator(final String pathServiceSid, 
                                       final String language, 
                                       final String query) {
        return new QueryCreator(pathServiceSid, language, query);
    }

    /**
     * Create a QueryUpdater to execute update.
     * 
     * @param pathServiceSid The service_sid
     * @param pathSid The sid
     * @return QueryUpdater capable of executing the update
     */
    public static QueryUpdater updater(final String pathServiceSid, 
                                       final String pathSid) {
        return new QueryUpdater(pathServiceSid, pathSid);
    }

    /**
     * Create a QueryDeleter to execute delete.
     * 
     * @param pathServiceSid The service_sid
     * @param pathSid The sid
     * @return QueryDeleter capable of executing the delete
     */
    public static QueryDeleter deleter(final String pathServiceSid, 
                                       final String pathSid) {
        return new QueryDeleter(pathServiceSid, pathSid);
    }

    /**
     * Converts a JSON String into a Query object using the provided ObjectMapper.
     * 
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Query object represented by the provided JSON
     */
    public static Query fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Query.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Query object using the provided
     * ObjectMapper.
     * 
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Query object represented by the provided JSON
     */
    public static Query fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Query.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Map<String, Object> results;
    private final String language;
    private final String modelBuildSid;
    private final String query;
    private final String sampleSid;
    private final String serviceSid;
    private final String sid;
    private final String status;
    private final URI url;

    @JsonCreator
    private Query(@JsonProperty("account_sid")
                  final String accountSid, 
                  @JsonProperty("date_created")
                  final String dateCreated, 
                  @JsonProperty("date_updated")
                  final String dateUpdated, 
                  @JsonProperty("results")
                  final Map<String, Object> results, 
                  @JsonProperty("language")
                  final String language, 
                  @JsonProperty("model_build_sid")
                  final String modelBuildSid, 
                  @JsonProperty("query")
                  final String query, 
                  @JsonProperty("sample_sid")
                  final String sampleSid, 
                  @JsonProperty("service_sid")
                  final String serviceSid, 
                  @JsonProperty("sid")
                  final String sid, 
                  @JsonProperty("status")
                  final String status, 
                  @JsonProperty("url")
                  final URI url) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.results = results;
        this.language = language;
        this.modelBuildSid = modelBuildSid;
        this.query = query;
        this.sampleSid = sampleSid;
        this.serviceSid = serviceSid;
        this.sid = sid;
        this.status = status;
        this.url = url;
    }

    /**
     * Returns The The account_sid.
     * 
     * @return The account_sid
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The The date_created.
     * 
     * @return The date_created
     */
    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The The date_updated.
     * 
     * @return The date_updated
     */
    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The The results.
     * 
     * @return The results
     */
    public final Map<String, Object> getResults() {
        return this.results;
    }

    /**
     * Returns The The language.
     * 
     * @return The language
     */
    public final String getLanguage() {
        return this.language;
    }

    /**
     * Returns The The model_build_sid.
     * 
     * @return The model_build_sid
     */
    public final String getModelBuildSid() {
        return this.modelBuildSid;
    }

    /**
     * Returns The The query.
     * 
     * @return The query
     */
    public final String getQuery() {
        return this.query;
    }

    /**
     * Returns The The sample_sid.
     * 
     * @return The sample_sid
     */
    public final String getSampleSid() {
        return this.sampleSid;
    }

    /**
     * Returns The The service_sid.
     * 
     * @return The service_sid
     */
    public final String getServiceSid() {
        return this.serviceSid;
    }

    /**
     * Returns The The sid.
     * 
     * @return The sid
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The The status.
     * 
     * @return The status
     */
    public final String getStatus() {
        return this.status;
    }

    /**
     * Returns The The url.
     * 
     * @return The url
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Query other = (Query) o;

        return Objects.equals(accountSid, other.accountSid) && 
               Objects.equals(dateCreated, other.dateCreated) && 
               Objects.equals(dateUpdated, other.dateUpdated) && 
               Objects.equals(results, other.results) && 
               Objects.equals(language, other.language) && 
               Objects.equals(modelBuildSid, other.modelBuildSid) && 
               Objects.equals(query, other.query) && 
               Objects.equals(sampleSid, other.sampleSid) && 
               Objects.equals(serviceSid, other.serviceSid) && 
               Objects.equals(sid, other.sid) && 
               Objects.equals(status, other.status) && 
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            dateCreated,
                            dateUpdated,
                            results,
                            language,
                            modelBuildSid,
                            query,
                            sampleSid,
                            serviceSid,
                            sid,
                            status,
                            url);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                          .add("accountSid", accountSid)
                          .add("dateCreated", dateCreated)
                          .add("dateUpdated", dateUpdated)
                          .add("results", results)
                          .add("language", language)
                          .add("modelBuildSid", modelBuildSid)
                          .add("query", query)
                          .add("sampleSid", sampleSid)
                          .add("serviceSid", serviceSid)
                          .add("sid", sid)
                          .add("status", status)
                          .add("url", url)
                          .toString();
    }
}