/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.understand.service.fieldtype;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import org.joda.time.DateTime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class FieldValue extends Resource {
    private static final long serialVersionUID = 183098291227326L;

    /**
     * Create a FieldValueFetcher to execute fetch.
     * 
     * @param pathServiceSid The service_sid
     * @param pathFieldTypeSid The field_type_sid
     * @param pathSid The sid
     * @return FieldValueFetcher capable of executing the fetch
     */
    public static FieldValueFetcher fetcher(final String pathServiceSid, 
                                            final String pathFieldTypeSid, 
                                            final String pathSid) {
        return new FieldValueFetcher(pathServiceSid, pathFieldTypeSid, pathSid);
    }

    /**
     * Create a FieldValueReader to execute read.
     * 
     * @param pathServiceSid The service_sid
     * @param pathFieldTypeSid The field_type_sid
     * @return FieldValueReader capable of executing the read
     */
    public static FieldValueReader reader(final String pathServiceSid, 
                                          final String pathFieldTypeSid) {
        return new FieldValueReader(pathServiceSid, pathFieldTypeSid);
    }

    /**
     * Create a FieldValueCreator to execute create.
     * 
     * @param pathServiceSid The service_sid
     * @param pathFieldTypeSid The field_type_sid
     * @param language The language
     * @param value The value
     * @return FieldValueCreator capable of executing the create
     */
    public static FieldValueCreator creator(final String pathServiceSid, 
                                            final String pathFieldTypeSid, 
                                            final String language, 
                                            final String value) {
        return new FieldValueCreator(pathServiceSid, pathFieldTypeSid, language, value);
    }

    /**
     * Create a FieldValueDeleter to execute delete.
     * 
     * @param pathServiceSid The service_sid
     * @param pathFieldTypeSid The field_type_sid
     * @param pathSid The sid
     * @return FieldValueDeleter capable of executing the delete
     */
    public static FieldValueDeleter deleter(final String pathServiceSid, 
                                            final String pathFieldTypeSid, 
                                            final String pathSid) {
        return new FieldValueDeleter(pathServiceSid, pathFieldTypeSid, pathSid);
    }

    /**
     * Converts a JSON String into a FieldValue object using the provided
     * ObjectMapper.
     * 
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return FieldValue object represented by the provided JSON
     */
    public static FieldValue fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, FieldValue.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a FieldValue object using the provided
     * ObjectMapper.
     * 
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return FieldValue object represented by the provided JSON
     */
    public static FieldValue fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, FieldValue.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String fieldTypeSid;
    private final String language;
    private final String serviceSid;
    private final String sid;
    private final String value;
    private final URI url;

    @JsonCreator
    private FieldValue(@JsonProperty("account_sid")
                       final String accountSid, 
                       @JsonProperty("date_created")
                       final String dateCreated, 
                       @JsonProperty("date_updated")
                       final String dateUpdated, 
                       @JsonProperty("field_type_sid")
                       final String fieldTypeSid, 
                       @JsonProperty("language")
                       final String language, 
                       @JsonProperty("service_sid")
                       final String serviceSid, 
                       @JsonProperty("sid")
                       final String sid, 
                       @JsonProperty("value")
                       final String value, 
                       @JsonProperty("url")
                       final URI url) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.fieldTypeSid = fieldTypeSid;
        this.language = language;
        this.serviceSid = serviceSid;
        this.sid = sid;
        this.value = value;
        this.url = url;
    }

    /**
     * Returns The The account_sid.
     * 
     * @return The account_sid
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The The date_created.
     * 
     * @return The date_created
     */
    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The The date_updated.
     * 
     * @return The date_updated
     */
    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The The field_type_sid.
     * 
     * @return The field_type_sid
     */
    public final String getFieldTypeSid() {
        return this.fieldTypeSid;
    }

    /**
     * Returns The The language.
     * 
     * @return The language
     */
    public final String getLanguage() {
        return this.language;
    }

    /**
     * Returns The The service_sid.
     * 
     * @return The service_sid
     */
    public final String getServiceSid() {
        return this.serviceSid;
    }

    /**
     * Returns The The sid.
     * 
     * @return The sid
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The The value.
     * 
     * @return The value
     */
    public final String getValue() {
        return this.value;
    }

    /**
     * Returns The The url.
     * 
     * @return The url
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        FieldValue other = (FieldValue) o;

        return Objects.equals(accountSid, other.accountSid) && 
               Objects.equals(dateCreated, other.dateCreated) && 
               Objects.equals(dateUpdated, other.dateUpdated) && 
               Objects.equals(fieldTypeSid, other.fieldTypeSid) && 
               Objects.equals(language, other.language) && 
               Objects.equals(serviceSid, other.serviceSid) && 
               Objects.equals(sid, other.sid) && 
               Objects.equals(value, other.value) && 
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            dateCreated,
                            dateUpdated,
                            fieldTypeSid,
                            language,
                            serviceSid,
                            sid,
                            value,
                            url);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                          .add("accountSid", accountSid)
                          .add("dateCreated", dateCreated)
                          .add("dateUpdated", dateUpdated)
                          .add("fieldTypeSid", fieldTypeSid)
                          .add("language", language)
                          .add("serviceSid", serviceSid)
                          .add("sid", sid)
                          .add("value", value)
                          .add("url", url)
                          .toString();
    }
}