/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.understand.service.intent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import org.joda.time.DateTime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Field extends Resource {
    private static final long serialVersionUID = 21328714176915L;

    /**
     * Create a FieldFetcher to execute fetch.
     * 
     * @param pathServiceSid The service_sid
     * @param pathIntentSid The intent_sid
     * @param pathSid The sid
     * @return FieldFetcher capable of executing the fetch
     */
    public static FieldFetcher fetcher(final String pathServiceSid, 
                                       final String pathIntentSid, 
                                       final String pathSid) {
        return new FieldFetcher(pathServiceSid, pathIntentSid, pathSid);
    }

    /**
     * Create a FieldReader to execute read.
     * 
     * @param pathServiceSid The service_sid
     * @param pathIntentSid The intent_sid
     * @return FieldReader capable of executing the read
     */
    public static FieldReader reader(final String pathServiceSid, 
                                     final String pathIntentSid) {
        return new FieldReader(pathServiceSid, pathIntentSid);
    }

    /**
     * Create a FieldCreator to execute create.
     * 
     * @param pathServiceSid The service_sid
     * @param pathIntentSid The intent_sid
     * @param fieldType The field_type
     * @param uniqueName The unique_name
     * @return FieldCreator capable of executing the create
     */
    public static FieldCreator creator(final String pathServiceSid, 
                                       final String pathIntentSid, 
                                       final String fieldType, 
                                       final String uniqueName) {
        return new FieldCreator(pathServiceSid, pathIntentSid, fieldType, uniqueName);
    }

    /**
     * Create a FieldDeleter to execute delete.
     * 
     * @param pathServiceSid The service_sid
     * @param pathIntentSid The intent_sid
     * @param pathSid The sid
     * @return FieldDeleter capable of executing the delete
     */
    public static FieldDeleter deleter(final String pathServiceSid, 
                                       final String pathIntentSid, 
                                       final String pathSid) {
        return new FieldDeleter(pathServiceSid, pathIntentSid, pathSid);
    }

    /**
     * Converts a JSON String into a Field object using the provided ObjectMapper.
     * 
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Field object represented by the provided JSON
     */
    public static Field fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Field.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Field object using the provided
     * ObjectMapper.
     * 
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Field object represented by the provided JSON
     */
    public static Field fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Field.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String fieldType;
    private final String intentSid;
    private final String serviceSid;
    private final String sid;
    private final String uniqueName;
    private final URI url;

    @JsonCreator
    private Field(@JsonProperty("account_sid")
                  final String accountSid, 
                  @JsonProperty("date_created")
                  final String dateCreated, 
                  @JsonProperty("date_updated")
                  final String dateUpdated, 
                  @JsonProperty("field_type")
                  final String fieldType, 
                  @JsonProperty("intent_sid")
                  final String intentSid, 
                  @JsonProperty("service_sid")
                  final String serviceSid, 
                  @JsonProperty("sid")
                  final String sid, 
                  @JsonProperty("unique_name")
                  final String uniqueName, 
                  @JsonProperty("url")
                  final URI url) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.fieldType = fieldType;
        this.intentSid = intentSid;
        this.serviceSid = serviceSid;
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.url = url;
    }

    /**
     * Returns The The account_sid.
     * 
     * @return The account_sid
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The The date_created.
     * 
     * @return The date_created
     */
    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The The date_updated.
     * 
     * @return The date_updated
     */
    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The The field_type.
     * 
     * @return The field_type
     */
    public final String getFieldType() {
        return this.fieldType;
    }

    /**
     * Returns The The intent_sid.
     * 
     * @return The intent_sid
     */
    public final String getIntentSid() {
        return this.intentSid;
    }

    /**
     * Returns The The service_sid.
     * 
     * @return The service_sid
     */
    public final String getServiceSid() {
        return this.serviceSid;
    }

    /**
     * Returns The The sid.
     * 
     * @return The sid
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The The unique_name.
     * 
     * @return The unique_name
     */
    public final String getUniqueName() {
        return this.uniqueName;
    }

    /**
     * Returns The The url.
     * 
     * @return The url
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Field other = (Field) o;

        return Objects.equals(accountSid, other.accountSid) && 
               Objects.equals(dateCreated, other.dateCreated) && 
               Objects.equals(dateUpdated, other.dateUpdated) && 
               Objects.equals(fieldType, other.fieldType) && 
               Objects.equals(intentSid, other.intentSid) && 
               Objects.equals(serviceSid, other.serviceSid) && 
               Objects.equals(sid, other.sid) && 
               Objects.equals(uniqueName, other.uniqueName) && 
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            dateCreated,
                            dateUpdated,
                            fieldType,
                            intentSid,
                            serviceSid,
                            sid,
                            uniqueName,
                            url);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                          .add("accountSid", accountSid)
                          .add("dateCreated", dateCreated)
                          .add("dateUpdated", dateUpdated)
                          .add("fieldType", fieldType)
                          .add("intentSid", intentSid)
                          .add("serviceSid", serviceSid)
                          .add("sid", sid)
                          .add("uniqueName", uniqueName)
                          .add("url", url)
                          .toString();
    }
}