/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.understand.service.intent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import org.joda.time.DateTime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Sample extends Resource {
    private static final long serialVersionUID = 190707008797131L;

    /**
     * Create a SampleFetcher to execute fetch.
     * 
     * @param pathServiceSid The service_sid
     * @param pathIntentSid The intent_sid
     * @param pathSid The sid
     * @return SampleFetcher capable of executing the fetch
     */
    public static SampleFetcher fetcher(final String pathServiceSid, 
                                        final String pathIntentSid, 
                                        final String pathSid) {
        return new SampleFetcher(pathServiceSid, pathIntentSid, pathSid);
    }

    /**
     * Create a SampleReader to execute read.
     * 
     * @param pathServiceSid The service_sid
     * @param pathIntentSid The intent_sid
     * @return SampleReader capable of executing the read
     */
    public static SampleReader reader(final String pathServiceSid, 
                                      final String pathIntentSid) {
        return new SampleReader(pathServiceSid, pathIntentSid);
    }

    /**
     * Create a SampleCreator to execute create.
     * 
     * @param pathServiceSid The service_sid
     * @param pathIntentSid The intent_sid
     * @param language The language
     * @param taggedText The tagged_text
     * @return SampleCreator capable of executing the create
     */
    public static SampleCreator creator(final String pathServiceSid, 
                                        final String pathIntentSid, 
                                        final String language, 
                                        final String taggedText) {
        return new SampleCreator(pathServiceSid, pathIntentSid, language, taggedText);
    }

    /**
     * Create a SampleUpdater to execute update.
     * 
     * @param pathServiceSid The service_sid
     * @param pathIntentSid The intent_sid
     * @param pathSid The sid
     * @return SampleUpdater capable of executing the update
     */
    public static SampleUpdater updater(final String pathServiceSid, 
                                        final String pathIntentSid, 
                                        final String pathSid) {
        return new SampleUpdater(pathServiceSid, pathIntentSid, pathSid);
    }

    /**
     * Create a SampleDeleter to execute delete.
     * 
     * @param pathServiceSid The service_sid
     * @param pathIntentSid The intent_sid
     * @param pathSid The sid
     * @return SampleDeleter capable of executing the delete
     */
    public static SampleDeleter deleter(final String pathServiceSid, 
                                        final String pathIntentSid, 
                                        final String pathSid) {
        return new SampleDeleter(pathServiceSid, pathIntentSid, pathSid);
    }

    /**
     * Converts a JSON String into a Sample object using the provided ObjectMapper.
     * 
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Sample object represented by the provided JSON
     */
    public static Sample fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Sample.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Sample object using the provided
     * ObjectMapper.
     * 
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Sample object represented by the provided JSON
     */
    public static Sample fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Sample.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String intentSid;
    private final String language;
    private final String serviceSid;
    private final String sid;
    private final String taggedText;
    private final URI url;

    @JsonCreator
    private Sample(@JsonProperty("account_sid")
                   final String accountSid, 
                   @JsonProperty("date_created")
                   final String dateCreated, 
                   @JsonProperty("date_updated")
                   final String dateUpdated, 
                   @JsonProperty("intent_sid")
                   final String intentSid, 
                   @JsonProperty("language")
                   final String language, 
                   @JsonProperty("service_sid")
                   final String serviceSid, 
                   @JsonProperty("sid")
                   final String sid, 
                   @JsonProperty("tagged_text")
                   final String taggedText, 
                   @JsonProperty("url")
                   final URI url) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.intentSid = intentSid;
        this.language = language;
        this.serviceSid = serviceSid;
        this.sid = sid;
        this.taggedText = taggedText;
        this.url = url;
    }

    /**
     * Returns The The account_sid.
     * 
     * @return The account_sid
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The The date_created.
     * 
     * @return The date_created
     */
    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The The date_updated.
     * 
     * @return The date_updated
     */
    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The The intent_sid.
     * 
     * @return The intent_sid
     */
    public final String getIntentSid() {
        return this.intentSid;
    }

    /**
     * Returns The The language.
     * 
     * @return The language
     */
    public final String getLanguage() {
        return this.language;
    }

    /**
     * Returns The The service_sid.
     * 
     * @return The service_sid
     */
    public final String getServiceSid() {
        return this.serviceSid;
    }

    /**
     * Returns The The sid.
     * 
     * @return The sid
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The The tagged_text.
     * 
     * @return The tagged_text
     */
    public final String getTaggedText() {
        return this.taggedText;
    }

    /**
     * Returns The The url.
     * 
     * @return The url
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Sample other = (Sample) o;

        return Objects.equals(accountSid, other.accountSid) && 
               Objects.equals(dateCreated, other.dateCreated) && 
               Objects.equals(dateUpdated, other.dateUpdated) && 
               Objects.equals(intentSid, other.intentSid) && 
               Objects.equals(language, other.language) && 
               Objects.equals(serviceSid, other.serviceSid) && 
               Objects.equals(sid, other.sid) && 
               Objects.equals(taggedText, other.taggedText) && 
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            dateCreated,
                            dateUpdated,
                            intentSid,
                            language,
                            serviceSid,
                            sid,
                            taggedText,
                            url);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                          .add("accountSid", accountSid)
                          .add("dateCreated", dateCreated)
                          .add("dateUpdated", dateUpdated)
                          .add("intentSid", intentSid)
                          .add("language", language)
                          .add("serviceSid", serviceSid)
                          .add("sid", sid)
                          .add("taggedText", taggedText)
                          .add("url", url)
                          .toString();
    }
}