/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.proxy.v1.service.session;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import org.joda.time.DateTime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Interaction extends Resource {
    private static final long serialVersionUID = 184706954085822L;

    public enum Type {
        MESSAGE("message"),
        VOICE("voice"),
        UNKNOWN("unknown");

        private final String value;

        private Type(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Type from a string.
         * @param value string value
         * @return generated Type
         */
        @JsonCreator
        public static Type forValue(final String value) {
            return Promoter.enumFromString(value, Type.values());
        }
    }

    public enum ResourceStatus {
        ACCEPTED("accepted"),
        ANSWERED("answered"),
        BUSY("busy"),
        CANCELED("canceled"),
        COMPLETED("completed"),
        DELETED("deleted"),
        DELIVERED("delivered"),
        DELIVERY_UNKNOWN("delivery-unknown"),
        FAILED("failed"),
        IN_PROGRESS("in-progress"),
        INITIATED("initiated"),
        NO_ANSWER("no-answer"),
        QUEUED("queued"),
        RECEIVED("received"),
        RECEIVING("receiving"),
        RINGING("ringing"),
        SCHEDULED("scheduled"),
        SENDING("sending"),
        SENT("sent"),
        UNDELIVERED("undelivered"),
        UNKNOWN("unknown");

        private final String value;

        private ResourceStatus(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a ResourceStatus from a string.
         * @param value string value
         * @return generated ResourceStatus
         */
        @JsonCreator
        public static ResourceStatus forValue(final String value) {
            return Promoter.enumFromString(value, ResourceStatus.values());
        }
    }

    /**
     * Create a InteractionFetcher to execute fetch.
     * 
     * @param pathServiceSid Service Sid.
     * @param pathSessionSid Session Sid.
     * @param pathSid A string that uniquely identifies this Interaction.
     * @return InteractionFetcher capable of executing the fetch
     */
    public static InteractionFetcher fetcher(final String pathServiceSid, 
                                             final String pathSessionSid, 
                                             final String pathSid) {
        return new InteractionFetcher(pathServiceSid, pathSessionSid, pathSid);
    }

    /**
     * Create a InteractionReader to execute read.
     * 
     * @param pathServiceSid Service Sid.
     * @param pathSessionSid Session Sid.
     * @return InteractionReader capable of executing the read
     */
    public static InteractionReader reader(final String pathServiceSid, 
                                           final String pathSessionSid) {
        return new InteractionReader(pathServiceSid, pathSessionSid);
    }

    /**
     * Create a InteractionDeleter to execute delete.
     * 
     * @param pathServiceSid Service Sid.
     * @param pathSessionSid Session Sid.
     * @param pathSid A string that uniquely identifies this Interaction.
     * @return InteractionDeleter capable of executing the delete
     */
    public static InteractionDeleter deleter(final String pathServiceSid, 
                                             final String pathSessionSid, 
                                             final String pathSid) {
        return new InteractionDeleter(pathServiceSid, pathSessionSid, pathSid);
    }

    /**
     * Converts a JSON String into a Interaction object using the provided
     * ObjectMapper.
     * 
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Interaction object represented by the provided JSON
     */
    public static Interaction fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Interaction.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Interaction object using the provided
     * ObjectMapper.
     * 
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Interaction object represented by the provided JSON
     */
    public static Interaction fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Interaction.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String sessionSid;
    private final String serviceSid;
    private final String accountSid;
    private final String data;
    private final Interaction.Type type;
    private final String inboundParticipantSid;
    private final String inboundResourceSid;
    private final Interaction.ResourceStatus inboundResourceStatus;
    private final String inboundResourceType;
    private final URI inboundResourceUrl;
    private final String outboundParticipantSid;
    private final String outboundResourceSid;
    private final Interaction.ResourceStatus outboundResourceStatus;
    private final String outboundResourceType;
    private final URI outboundResourceUrl;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    @JsonCreator
    private Interaction(@JsonProperty("sid")
                        final String sid, 
                        @JsonProperty("session_sid")
                        final String sessionSid, 
                        @JsonProperty("service_sid")
                        final String serviceSid, 
                        @JsonProperty("account_sid")
                        final String accountSid, 
                        @JsonProperty("data")
                        final String data, 
                        @JsonProperty("type")
                        final Interaction.Type type, 
                        @JsonProperty("inbound_participant_sid")
                        final String inboundParticipantSid, 
                        @JsonProperty("inbound_resource_sid")
                        final String inboundResourceSid, 
                        @JsonProperty("inbound_resource_status")
                        final Interaction.ResourceStatus inboundResourceStatus, 
                        @JsonProperty("inbound_resource_type")
                        final String inboundResourceType, 
                        @JsonProperty("inbound_resource_url")
                        final URI inboundResourceUrl, 
                        @JsonProperty("outbound_participant_sid")
                        final String outboundParticipantSid, 
                        @JsonProperty("outbound_resource_sid")
                        final String outboundResourceSid, 
                        @JsonProperty("outbound_resource_status")
                        final Interaction.ResourceStatus outboundResourceStatus, 
                        @JsonProperty("outbound_resource_type")
                        final String outboundResourceType, 
                        @JsonProperty("outbound_resource_url")
                        final URI outboundResourceUrl, 
                        @JsonProperty("date_created")
                        final String dateCreated, 
                        @JsonProperty("date_updated")
                        final String dateUpdated, 
                        @JsonProperty("url")
                        final URI url) {
        this.sid = sid;
        this.sessionSid = sessionSid;
        this.serviceSid = serviceSid;
        this.accountSid = accountSid;
        this.data = data;
        this.type = type;
        this.inboundParticipantSid = inboundParticipantSid;
        this.inboundResourceSid = inboundResourceSid;
        this.inboundResourceStatus = inboundResourceStatus;
        this.inboundResourceType = inboundResourceType;
        this.inboundResourceUrl = inboundResourceUrl;
        this.outboundParticipantSid = outboundParticipantSid;
        this.outboundResourceSid = outboundResourceSid;
        this.outboundResourceStatus = outboundResourceStatus;
        this.outboundResourceType = outboundResourceType;
        this.outboundResourceUrl = outboundResourceUrl;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    /**
     * Returns The A string that uniquely identifies this Interaction..
     * 
     * @return A string that uniquely identifies this Interaction.
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The Session Sid..
     * 
     * @return Session Sid.
     */
    public final String getSessionSid() {
        return this.sessionSid;
    }

    /**
     * Returns The Service Sid..
     * 
     * @return Service Sid.
     */
    public final String getServiceSid() {
        return this.serviceSid;
    }

    /**
     * Returns The Account Sid..
     * 
     * @return Account Sid.
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The Further details about an interaction..
     * 
     * @return Further details about an interaction.
     */
    public final String getData() {
        return this.data;
    }

    /**
     * Returns The The Type of this Interaction.
     * 
     * @return The Type of this Interaction
     */
    public final Interaction.Type getType() {
        return this.type;
    }

    /**
     * Returns The Inbound Participant Sid..
     * 
     * @return Inbound Participant Sid.
     */
    public final String getInboundParticipantSid() {
        return this.inboundParticipantSid;
    }

    /**
     * Returns The Inbound Resource Sid..
     * 
     * @return Inbound Resource Sid.
     */
    public final String getInboundResourceSid() {
        return this.inboundResourceSid;
    }

    /**
     * Returns The The Inbound Resource Status of this Interaction.
     * 
     * @return The Inbound Resource Status of this Interaction
     */
    public final Interaction.ResourceStatus getInboundResourceStatus() {
        return this.inboundResourceStatus;
    }

    /**
     * Returns The The type of the Inbound Resource, Call or Message..
     * 
     * @return The type of the Inbound Resource, Call or Message.
     */
    public final String getInboundResourceType() {
        return this.inboundResourceType;
    }

    /**
     * Returns The The URL of the Twilio resource..
     * 
     * @return The URL of the Twilio resource.
     */
    public final URI getInboundResourceUrl() {
        return this.inboundResourceUrl;
    }

    /**
     * Returns The Outbound Participant Sid..
     * 
     * @return Outbound Participant Sid.
     */
    public final String getOutboundParticipantSid() {
        return this.outboundParticipantSid;
    }

    /**
     * Returns The Outbound Resource Sid..
     * 
     * @return Outbound Resource Sid.
     */
    public final String getOutboundResourceSid() {
        return this.outboundResourceSid;
    }

    /**
     * Returns The The Outbound Resource Status of this Interaction.
     * 
     * @return The Outbound Resource Status of this Interaction
     */
    public final Interaction.ResourceStatus getOutboundResourceStatus() {
        return this.outboundResourceStatus;
    }

    /**
     * Returns The The type of the Outbound Resource, Call or Message..
     * 
     * @return The type of the Outbound Resource, Call or Message.
     */
    public final String getOutboundResourceType() {
        return this.outboundResourceType;
    }

    /**
     * Returns The The URL of the Twilio resource..
     * 
     * @return The URL of the Twilio resource.
     */
    public final URI getOutboundResourceUrl() {
        return this.outboundResourceUrl;
    }

    /**
     * Returns The The date this Interaction was created.
     * 
     * @return The date this Interaction was created
     */
    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The The date this Interaction was updated.
     * 
     * @return The date this Interaction was updated
     */
    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The The URL of this resource..
     * 
     * @return The URL of this resource.
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Interaction other = (Interaction) o;

        return Objects.equals(sid, other.sid) && 
               Objects.equals(sessionSid, other.sessionSid) && 
               Objects.equals(serviceSid, other.serviceSid) && 
               Objects.equals(accountSid, other.accountSid) && 
               Objects.equals(data, other.data) && 
               Objects.equals(type, other.type) && 
               Objects.equals(inboundParticipantSid, other.inboundParticipantSid) && 
               Objects.equals(inboundResourceSid, other.inboundResourceSid) && 
               Objects.equals(inboundResourceStatus, other.inboundResourceStatus) && 
               Objects.equals(inboundResourceType, other.inboundResourceType) && 
               Objects.equals(inboundResourceUrl, other.inboundResourceUrl) && 
               Objects.equals(outboundParticipantSid, other.outboundParticipantSid) && 
               Objects.equals(outboundResourceSid, other.outboundResourceSid) && 
               Objects.equals(outboundResourceStatus, other.outboundResourceStatus) && 
               Objects.equals(outboundResourceType, other.outboundResourceType) && 
               Objects.equals(outboundResourceUrl, other.outboundResourceUrl) && 
               Objects.equals(dateCreated, other.dateCreated) && 
               Objects.equals(dateUpdated, other.dateUpdated) && 
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            sessionSid,
                            serviceSid,
                            accountSid,
                            data,
                            type,
                            inboundParticipantSid,
                            inboundResourceSid,
                            inboundResourceStatus,
                            inboundResourceType,
                            inboundResourceUrl,
                            outboundParticipantSid,
                            outboundResourceSid,
                            outboundResourceStatus,
                            outboundResourceType,
                            outboundResourceUrl,
                            dateCreated,
                            dateUpdated,
                            url);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                          .add("sid", sid)
                          .add("sessionSid", sessionSid)
                          .add("serviceSid", serviceSid)
                          .add("accountSid", accountSid)
                          .add("data", data)
                          .add("type", type)
                          .add("inboundParticipantSid", inboundParticipantSid)
                          .add("inboundResourceSid", inboundResourceSid)
                          .add("inboundResourceStatus", inboundResourceStatus)
                          .add("inboundResourceType", inboundResourceType)
                          .add("inboundResourceUrl", inboundResourceUrl)
                          .add("outboundParticipantSid", outboundParticipantSid)
                          .add("outboundResourceSid", outboundResourceSid)
                          .add("outboundResourceStatus", outboundResourceStatus)
                          .add("outboundResourceType", outboundResourceType)
                          .add("outboundResourceUrl", outboundResourceUrl)
                          .add("dateCreated", dateCreated)
                          .add("dateUpdated", dateUpdated)
                          .add("url", url)
                          .toString();
    }
}