/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.taskrouter.v1;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.net.URI;

public class WorkspaceUpdater extends Updater<Workspace> {
    private final String pathSid;
    private String defaultActivitySid;
    private URI eventCallbackUrl;
    private String eventsFilter;
    private String friendlyName;
    private Boolean multiTaskEnabled;
    private String timeoutActivitySid;
    private Workspace.QueueOrder prioritizeQueueOrder;

    /**
     * Construct a new WorkspaceUpdater.
     * 
     * @param pathSid The sid
     */
    public WorkspaceUpdater(final String pathSid) {
        this.pathSid = pathSid;
    }

    /**
     * The default_activity_sid.
     * 
     * @param defaultActivitySid The default_activity_sid
     * @return this
     */
    public WorkspaceUpdater setDefaultActivitySid(final String defaultActivitySid) {
        this.defaultActivitySid = defaultActivitySid;
        return this;
    }

    /**
     * The event_callback_url.
     * 
     * @param eventCallbackUrl The event_callback_url
     * @return this
     */
    public WorkspaceUpdater setEventCallbackUrl(final URI eventCallbackUrl) {
        this.eventCallbackUrl = eventCallbackUrl;
        return this;
    }

    /**
     * The event_callback_url.
     * 
     * @param eventCallbackUrl The event_callback_url
     * @return this
     */
    public WorkspaceUpdater setEventCallbackUrl(final String eventCallbackUrl) {
        return setEventCallbackUrl(Promoter.uriFromString(eventCallbackUrl));
    }

    /**
     * The events_filter.
     * 
     * @param eventsFilter The events_filter
     * @return this
     */
    public WorkspaceUpdater setEventsFilter(final String eventsFilter) {
        this.eventsFilter = eventsFilter;
        return this;
    }

    /**
     * The friendly_name.
     * 
     * @param friendlyName The friendly_name
     * @return this
     */
    public WorkspaceUpdater setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    /**
     * The multi_task_enabled.
     * 
     * @param multiTaskEnabled The multi_task_enabled
     * @return this
     */
    public WorkspaceUpdater setMultiTaskEnabled(final Boolean multiTaskEnabled) {
        this.multiTaskEnabled = multiTaskEnabled;
        return this;
    }

    /**
     * The timeout_activity_sid.
     * 
     * @param timeoutActivitySid The timeout_activity_sid
     * @return this
     */
    public WorkspaceUpdater setTimeoutActivitySid(final String timeoutActivitySid) {
        this.timeoutActivitySid = timeoutActivitySid;
        return this;
    }

    /**
     * The prioritize_queue_order.
     * 
     * @param prioritizeQueueOrder The prioritize_queue_order
     * @return this
     */
    public WorkspaceUpdater setPrioritizeQueueOrder(final Workspace.QueueOrder prioritizeQueueOrder) {
        this.prioritizeQueueOrder = prioritizeQueueOrder;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return Updated Workspace
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Workspace update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.TASKROUTER.toString(),
            "/v1/Workspaces/" + this.pathSid + "",
            client.getRegion()
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Workspace update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }

            throw new ApiException(
                restException.getMessage(),
                restException.getCode(),
                restException.getMoreInfo(),
                restException.getStatus(),
                null
            );
        }

        return Workspace.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     * 
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (defaultActivitySid != null) {
            request.addPostParam("DefaultActivitySid", defaultActivitySid);
        }

        if (eventCallbackUrl != null) {
            request.addPostParam("EventCallbackUrl", eventCallbackUrl.toString());
        }

        if (eventsFilter != null) {
            request.addPostParam("EventsFilter", eventsFilter);
        }

        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (multiTaskEnabled != null) {
            request.addPostParam("MultiTaskEnabled", multiTaskEnabled.toString());
        }

        if (timeoutActivitySid != null) {
            request.addPostParam("TimeoutActivitySid", timeoutActivitySid);
        }

        if (prioritizeQueueOrder != null) {
            request.addPostParam("PrioritizeQueueOrder", prioritizeQueueOrder.toString());
        }
    }
}