/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.taskrouter.v1.workspace.taskqueue;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class TaskQueueRealTimeStatistics extends Resource {
    private static final long serialVersionUID = 165753411245187L;

    /**
     * Create a TaskQueueRealTimeStatisticsFetcher to execute fetch.
     * 
     * @param pathWorkspaceSid The workspace_sid
     * @param pathTaskQueueSid The task_queue_sid
     * @return TaskQueueRealTimeStatisticsFetcher capable of executing the fetch
     */
    public static TaskQueueRealTimeStatisticsFetcher fetcher(final String pathWorkspaceSid, 
                                                             final String pathTaskQueueSid) {
        return new TaskQueueRealTimeStatisticsFetcher(pathWorkspaceSid, pathTaskQueueSid);
    }

    /**
     * Converts a JSON String into a TaskQueueRealTimeStatistics object using the
     * provided ObjectMapper.
     * 
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return TaskQueueRealTimeStatistics object represented by the provided JSON
     */
    public static TaskQueueRealTimeStatistics fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, TaskQueueRealTimeStatistics.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a TaskQueueRealTimeStatistics object using
     * the provided ObjectMapper.
     * 
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return TaskQueueRealTimeStatistics object represented by the provided JSON
     */
    public static TaskQueueRealTimeStatistics fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, TaskQueueRealTimeStatistics.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final List<Map<String, Object>> activityStatistics;
    private final Integer longestTaskWaitingAge;
    private final String taskQueueSid;
    private final Map<String, Object> tasksByPriority;
    private final Map<String, Object> tasksByStatus;
    private final Integer totalAvailableWorkers;
    private final Integer totalEligibleWorkers;
    private final Integer totalTasks;
    private final String workspaceSid;
    private final URI url;

    @JsonCreator
    private TaskQueueRealTimeStatistics(@JsonProperty("account_sid")
                                        final String accountSid, 
                                        @JsonProperty("activity_statistics")
                                        final List<Map<String, Object>> activityStatistics, 
                                        @JsonProperty("longest_task_waiting_age")
                                        final Integer longestTaskWaitingAge, 
                                        @JsonProperty("task_queue_sid")
                                        final String taskQueueSid, 
                                        @JsonProperty("tasks_by_priority")
                                        final Map<String, Object> tasksByPriority, 
                                        @JsonProperty("tasks_by_status")
                                        final Map<String, Object> tasksByStatus, 
                                        @JsonProperty("total_available_workers")
                                        final Integer totalAvailableWorkers, 
                                        @JsonProperty("total_eligible_workers")
                                        final Integer totalEligibleWorkers, 
                                        @JsonProperty("total_tasks")
                                        final Integer totalTasks, 
                                        @JsonProperty("workspace_sid")
                                        final String workspaceSid, 
                                        @JsonProperty("url")
                                        final URI url) {
        this.accountSid = accountSid;
        this.activityStatistics = activityStatistics;
        this.longestTaskWaitingAge = longestTaskWaitingAge;
        this.taskQueueSid = taskQueueSid;
        this.tasksByPriority = tasksByPriority;
        this.tasksByStatus = tasksByStatus;
        this.totalAvailableWorkers = totalAvailableWorkers;
        this.totalEligibleWorkers = totalEligibleWorkers;
        this.totalTasks = totalTasks;
        this.workspaceSid = workspaceSid;
        this.url = url;
    }

    /**
     * Returns The The account_sid.
     * 
     * @return The account_sid
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The The activity_statistics.
     * 
     * @return The activity_statistics
     */
    public final List<Map<String, Object>> getActivityStatistics() {
        return this.activityStatistics;
    }

    /**
     * Returns The The longest_task_waiting_age.
     * 
     * @return The longest_task_waiting_age
     */
    public final Integer getLongestTaskWaitingAge() {
        return this.longestTaskWaitingAge;
    }

    /**
     * Returns The The task_queue_sid.
     * 
     * @return The task_queue_sid
     */
    public final String getTaskQueueSid() {
        return this.taskQueueSid;
    }

    /**
     * Returns The The tasks_by_priority.
     * 
     * @return The tasks_by_priority
     */
    public final Map<String, Object> getTasksByPriority() {
        return this.tasksByPriority;
    }

    /**
     * Returns The The tasks_by_status.
     * 
     * @return The tasks_by_status
     */
    public final Map<String, Object> getTasksByStatus() {
        return this.tasksByStatus;
    }

    /**
     * Returns The The total_available_workers.
     * 
     * @return The total_available_workers
     */
    public final Integer getTotalAvailableWorkers() {
        return this.totalAvailableWorkers;
    }

    /**
     * Returns The The total_eligible_workers.
     * 
     * @return The total_eligible_workers
     */
    public final Integer getTotalEligibleWorkers() {
        return this.totalEligibleWorkers;
    }

    /**
     * Returns The The total_tasks.
     * 
     * @return The total_tasks
     */
    public final Integer getTotalTasks() {
        return this.totalTasks;
    }

    /**
     * Returns The The workspace_sid.
     * 
     * @return The workspace_sid
     */
    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    /**
     * Returns The The url.
     * 
     * @return The url
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        TaskQueueRealTimeStatistics other = (TaskQueueRealTimeStatistics) o;

        return Objects.equals(accountSid, other.accountSid) && 
               Objects.equals(activityStatistics, other.activityStatistics) && 
               Objects.equals(longestTaskWaitingAge, other.longestTaskWaitingAge) && 
               Objects.equals(taskQueueSid, other.taskQueueSid) && 
               Objects.equals(tasksByPriority, other.tasksByPriority) && 
               Objects.equals(tasksByStatus, other.tasksByStatus) && 
               Objects.equals(totalAvailableWorkers, other.totalAvailableWorkers) && 
               Objects.equals(totalEligibleWorkers, other.totalEligibleWorkers) && 
               Objects.equals(totalTasks, other.totalTasks) && 
               Objects.equals(workspaceSid, other.workspaceSid) && 
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            activityStatistics,
                            longestTaskWaitingAge,
                            taskQueueSid,
                            tasksByPriority,
                            tasksByStatus,
                            totalAvailableWorkers,
                            totalEligibleWorkers,
                            totalTasks,
                            workspaceSid,
                            url);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                          .add("accountSid", accountSid)
                          .add("activityStatistics", activityStatistics)
                          .add("longestTaskWaitingAge", longestTaskWaitingAge)
                          .add("taskQueueSid", taskQueueSid)
                          .add("tasksByPriority", tasksByPriority)
                          .add("tasksByStatus", tasksByStatus)
                          .add("totalAvailableWorkers", totalAvailableWorkers)
                          .add("totalEligibleWorkers", totalEligibleWorkers)
                          .add("totalTasks", totalTasks)
                          .add("workspaceSid", workspaceSid)
                          .add("url", url)
                          .toString();
    }
}