/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.taskrouter.v1.workspace.worker;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class WorkerChannelUpdater extends Updater<WorkerChannel> {
    private final String pathWorkspaceSid;
    private final String pathWorkerSid;
    private final String pathSid;
    private Integer capacity;
    private Boolean available;

    /**
     * Construct a new WorkerChannelUpdater.
     * 
     * @param pathWorkspaceSid The workspace_sid
     * @param pathWorkerSid The worker_sid
     * @param pathSid The sid
     */
    public WorkerChannelUpdater(final String pathWorkspaceSid, 
                                final String pathWorkerSid, 
                                final String pathSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.pathWorkerSid = pathWorkerSid;
        this.pathSid = pathSid;
    }

    /**
     * The capacity.
     * 
     * @param capacity The capacity
     * @return this
     */
    public WorkerChannelUpdater setCapacity(final Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    /**
     * The available.
     * 
     * @param available The available
     * @return this
     */
    public WorkerChannelUpdater setAvailable(final Boolean available) {
        this.available = available;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return Updated WorkerChannel
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public WorkerChannel update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.TASKROUTER.toString(),
            "/v1/Workspaces/" + this.pathWorkspaceSid + "/Workers/" + this.pathWorkerSid + "/Channels/" + this.pathSid + "",
            client.getRegion()
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("WorkerChannel update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }

            throw new ApiException(
                restException.getMessage(),
                restException.getCode(),
                restException.getMoreInfo(),
                restException.getStatus(),
                null
            );
        }

        return WorkerChannel.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     * 
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (capacity != null) {
            request.addPostParam("Capacity", capacity.toString());
        }

        if (available != null) {
            request.addPostParam("Available", available.toString());
        }
    }
}